<?php

/**
 * BaseWRTeam
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                $id                                       Type: integer(4), primary key
 * @property string                             $date_from                                Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                             $date_to                                  Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                             $name                                     Type: string(24)
 * @property int                                $judgecount                               Type: integer(1)
 * @property int                                $event_id                                 Type: integer(4)
 * @property string                             $serialized_preset                        Type: string
 * @property string                             $wettbewerbsart                           Type: string(24), default "Einzel"
 * @property Event                              $Event                                    
 * @property Doctrine_Collection|Assignment[]   $Assignments                              
 * @property Doctrine_Collection|Competition[]  $Competitions                             
 *  
 * @method int                                  getId()                                   Type: integer(4), primary key
 * @method string                               getDateFrom()                             Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                               getDateTo()                               Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                               getName()                                 Type: string(24)
 * @method int                                  getJudgecount()                           Type: integer(1)
 * @method int                                  getEventId()                              Type: integer(4)
 * @method string                               getSerializedPreset()                     Type: string
 * @method string                               getWettbewerbsart()                       Type: string(24), default "Einzel"
 * @method Event                                getEvent()                                
 * @method Doctrine_Collection|Assignment[]     getAssignments()                          
 * @method Doctrine_Collection|Competition[]    getCompetitions()                         
 *  
 * @method WRTeam                               setId(int $val)                           Type: integer(4), primary key
 * @method WRTeam                               setDateFrom(string $val)                  Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method WRTeam                               setDateTo(string $val)                    Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method WRTeam                               setName(string $val)                      Type: string(24)
 * @method WRTeam                               setJudgecount(int $val)                   Type: integer(1)
 * @method WRTeam                               setEventId(int $val)                      Type: integer(4)
 * @method WRTeam                               setSerializedPreset(string $val)          Type: string
 * @method WRTeam                               setWettbewerbsart(string $val)            Type: string(24), default "Einzel"
 * @method WRTeam                               setEvent(Event $val)                      
 * @method WRTeam                               setAssignments(Doctrine_Collection $val)  
 * @method WRTeam                               setCompetitions(Doctrine_Collection $val) 
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseWRTeam extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('wrteams');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('date_from', 'date', 25, array(
             'type' => 'date',
             'notnull' => true,
             'primary' => false,
             'autoincrement' => false,
             'length' => '25',
             ));
        $this->hasColumn('date_to', 'date', 25, array(
             'type' => 'date',
             'notnull' => false,
             'primary' => false,
             'autoincrement' => false,
             'length' => '25',
             ));
        $this->hasColumn('name', 'string', 24, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '24',
             ));
        $this->hasColumn('judgecount', 'integer', 1, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '1',
             ));
        $this->hasColumn('event_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('serialized_preset', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('wettbewerbsart', 'string', 24, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'default' => 'Einzel',
             'length' => '24',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Event', array(
             'local' => 'event_id',
             'foreign' => 'id'));

        $this->hasMany('Assignment as Assignments', array(
             'local' => 'id',
             'foreign' => 'team_id'));

        $this->hasMany('Competition as Competitions', array(
             'local' => 'id',
             'foreign' => 'team_id'));

        $datetimebehavior0 = new DateTimeBehavior();
        $this->actAs($datetimebehavior0);
    }
}