<?php

/**
 * BaseUser
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                       $id                                              Type: integer(4), primary key
 * @property string                                    $liznr                                           Type: string(5)
 * @property string                                    $dtvnr                                           Type: string(11)
 * @property string                                    $title                                           Type: string(32)
 * @property string                                    $name                                            Type: string(32)
 * @property string                                    $surname                                         Type: string(32)
 * @property string                                    $gender                                          Type: string(1) fixed-size
 * @property string                                    $email                                           Type: string(64)
 * @property string                                    $phone                                           Type: string(24)
 * @property string                                    $strasse                                         Type: string(48)
 * @property string                                    $plz                                             Type: string(12)
 * @property string                                    $ort                                             Type: string(48)
 * @property int                                       $land                                            Type: int(4)
 * @property int                                       $geburtsjahr                                     Type: integer(4)
 * @property string                                    $passwd                                          Type: string(32)
 * @property int                                       $club_id                                         Type: integer(4)
 * @property int                                       $license_st_id                                   Type: integer(4)
 * @property int                                       $license_lat_id                                  Type: integer(4)
 * @property int                                       $license_effective_id                            Type: integer(4)
 * @property int                                       $license_st_effective_id                         Type: integer(4)
 * @property int                                       $license_lat_effective_id                        Type: integer(4)
 * @property int                                       $license_kombi_effective_id                      Type: integer(4)
 * @property int                                       $license_form_id                                 Type: integer(4)
 * @property int                                       $active                                          Type: integer(2), default "3"
 * @property string                                    $lastlogin                                       Type: date(25), default "1970-01-01", Date in ISO-8601 format (YYYY-MM-DD)
 * @property int                                       $fails                                           Type: integer(1), default "0"
 * @property string                                    $activation_code                                 Type: string(36)
 * @property string                                    $chpw_code                                       Type: string(36)
 * @property string                                    $registered                                      Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                                    $validated                                       Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                                    $activated                                       Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                                    $bemerkungen                                     Type: string(255)
 * @property string                                    $mobile                                          Type: string(24)
 * @property int                                       $default_mandator_id                             Type: integer(4)
 * @property string                                    $esv_check                                       Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property object                                    $esv_data                                        Type: blob
 * @property string                                    $gdpr_terms_consent                              Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property int                                       $gdpr_terms_version                              Type: integer(1), default "1"
 * @property string                                    $listing_consent                                 Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property int                                       $primary_mandator_id                             Type: integer(4)
 * @property int                                       $last_license_year                               Type: integer(4)
 * @property License                                   $LicenseLat                                      
 * @property License                                   $LicenseSt                                       
 * @property License                                   $LicenseEffective                                
 * @property License                                   $LicenseLatEffective                             
 * @property License                                   $LicenseStEffective                              
 * @property License                                   $LicenseKombiEffective                           
 * @property License                                   $LicenseForm                                     
 * @property Club                                      $Club                                            
 * @property Doctrine_Collection|Assignment[]          $Assignments                                     
 * @property Doctrine_Collection|Availability[]        $Availabilities                                  
 * @property Doctrine_Collection|ChangeEmailRequest[]  $ChangeEmailRequests                             
 * @property Doctrine_Collection|SystemGrant[]         $SystemGrants                                    
 * @property Mandator                                  $DefaultMandator                                 
 * @property Country                                   $Country                                         
 * @property Mandator                                  $PrimaryMandator                                 
 * @property Doctrine_Collection|PersistentSetting[]   $PersistentSetting                               
 * @property Doctrine_Collection|Role[]                $Roles                                           
 * @property Doctrine_Collection|Mandator[]            $AvailableMandators                              
 * @property Doctrine_Collection|MandatorGrant[]       $MandatorGrants                                  
 *  
 * @method int                                         getId()                                          Type: integer(4), primary key
 * @method string                                      getLiznr()                                       Type: string(5)
 * @method string                                      getDtvnr()                                       Type: string(11)
 * @method string                                      getTitle()                                       Type: string(32)
 * @method string                                      getName()                                        Type: string(32)
 * @method string                                      getSurname()                                     Type: string(32)
 * @method string                                      getGender()                                      Type: string(1) fixed-size
 * @method string                                      getEmail()                                       Type: string(64)
 * @method string                                      getPhone()                                       Type: string(24)
 * @method string                                      getStrasse()                                     Type: string(48)
 * @method string                                      getPlz()                                         Type: string(12)
 * @method string                                      getOrt()                                         Type: string(48)
 * @method int                                         getLand()                                        Type: int(4)
 * @method int                                         getGeburtsjahr()                                 Type: integer(4)
 * @method string                                      getPasswd()                                      Type: string(32)
 * @method int                                         getClubId()                                      Type: integer(4)
 * @method int                                         getLicenseStId()                                 Type: integer(4)
 * @method int                                         getLicenseLatId()                                Type: integer(4)
 * @method int                                         getLicenseEffectiveId()                          Type: integer(4)
 * @method int                                         getLicenseStEffectiveId()                        Type: integer(4)
 * @method int                                         getLicenseLatEffectiveId()                       Type: integer(4)
 * @method int                                         getLicenseKombiEffectiveId()                     Type: integer(4)
 * @method int                                         getLicenseFormId()                               Type: integer(4)
 * @method int                                         getActive()                                      Type: integer(2), default "3"
 * @method string                                      getLastlogin()                                   Type: date(25), default "1970-01-01", Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                                         getFails()                                       Type: integer(1), default "0"
 * @method string                                      getActivationCode()                              Type: string(36)
 * @method string                                      getChpwCode()                                    Type: string(36)
 * @method string                                      getRegistered()                                  Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                                      getValidated()                                   Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                                      getActivated()                                   Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                                      getBemerkungen()                                 Type: string(255)
 * @method string                                      getMobile()                                      Type: string(24)
 * @method int                                         getDefaultMandatorId()                           Type: integer(4)
 * @method string                                      getEsvCheck()                                    Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method object                                      getEsvData()                                     Type: blob
 * @method string                                      getGdprTermsConsent()                            Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method int                                         getGdprTermsVersion()                            Type: integer(1), default "1"
 * @method string                                      getListingConsent()                              Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method int                                         getPrimaryMandatorId()                           Type: integer(4)
 * @method int                                         getLastLicenseYear()                             Type: integer(4)
 * @method License                                     getLicenseLat()                                  
 * @method License                                     getLicenseSt()                                   
 * @method License                                     getLicenseEffective()                            
 * @method License                                     getLicenseLatEffective()                         
 * @method License                                     getLicenseStEffective()                          
 * @method License                                     getLicenseKombiEffective()                       
 * @method License                                     getLicenseForm()                                 
 * @method Club                                        getClub()                                        
 * @method Doctrine_Collection|Assignment[]            getAssignments()                                 
 * @method Doctrine_Collection|Availability[]          getAvailabilities()                              
 * @method Doctrine_Collection|ChangeEmailRequest[]    getChangeEmailRequests()                         
 * @method Doctrine_Collection|SystemGrant[]           getSystemGrants()                                
 * @method Mandator                                    getDefaultMandator()                             
 * @method Country                                     getCountry()                                     
 * @method Mandator                                    getPrimaryMandator()                             
 * @method Doctrine_Collection|PersistentSetting[]     getPersistentSetting()                           
 * @method Doctrine_Collection|Role[]                  getRoles()                                       
 * @method Doctrine_Collection|Mandator[]              getAvailableMandators()                          
 * @method Doctrine_Collection|MandatorGrant[]         getMandatorGrants()                              
 *  
 * @method User                                        setId(int $val)                                  Type: integer(4), primary key
 * @method User                                        setLiznr(string $val)                            Type: string(5)
 * @method User                                        setDtvnr(string $val)                            Type: string(11)
 * @method User                                        setTitle(string $val)                            Type: string(32)
 * @method User                                        setName(string $val)                             Type: string(32)
 * @method User                                        setSurname(string $val)                          Type: string(32)
 * @method User                                        setGender(string $val)                           Type: string(1) fixed-size
 * @method User                                        setEmail(string $val)                            Type: string(64)
 * @method User                                        setPhone(string $val)                            Type: string(24)
 * @method User                                        setStrasse(string $val)                          Type: string(48)
 * @method User                                        setPlz(string $val)                              Type: string(12)
 * @method User                                        setOrt(string $val)                              Type: string(48)
 * @method User                                        setLand(int $val)                                Type: int(4)
 * @method User                                        setGeburtsjahr(int $val)                         Type: integer(4)
 * @method User                                        setPasswd(string $val)                           Type: string(32)
 * @method User                                        setClubId(int $val)                              Type: integer(4)
 * @method User                                        setLicenseStId(int $val)                         Type: integer(4)
 * @method User                                        setLicenseLatId(int $val)                        Type: integer(4)
 * @method User                                        setLicenseEffectiveId(int $val)                  Type: integer(4)
 * @method User                                        setLicenseStEffectiveId(int $val)                Type: integer(4)
 * @method User                                        setLicenseLatEffectiveId(int $val)               Type: integer(4)
 * @method User                                        setLicenseKombiEffectiveId(int $val)             Type: integer(4)
 * @method User                                        setLicenseFormId(int $val)                       Type: integer(4)
 * @method User                                        setActive(int $val)                              Type: integer(2), default "3"
 * @method User                                        setLastlogin(string $val)                        Type: date(25), default "1970-01-01", Date in ISO-8601 format (YYYY-MM-DD)
 * @method User                                        setFails(int $val)                               Type: integer(1), default "0"
 * @method User                                        setActivationCode(string $val)                   Type: string(36)
 * @method User                                        setChpwCode(string $val)                         Type: string(36)
 * @method User                                        setRegistered(string $val)                       Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method User                                        setValidated(string $val)                        Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method User                                        setActivated(string $val)                        Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method User                                        setBemerkungen(string $val)                      Type: string(255)
 * @method User                                        setMobile(string $val)                           Type: string(24)
 * @method User                                        setDefaultMandatorId(int $val)                   Type: integer(4)
 * @method User                                        setEsvCheck(string $val)                         Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method User                                        setEsvData(object $val)                          Type: blob
 * @method User                                        setGdprTermsConsent(string $val)                 Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method User                                        setGdprTermsVersion(int $val)                    Type: integer(1), default "1"
 * @method User                                        setListingConsent(string $val)                   Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method User                                        setPrimaryMandatorId(int $val)                   Type: integer(4)
 * @method User                                        setLastLicenseYear(int $val)                     Type: integer(4)
 * @method User                                        setLicenseLat(License $val)                      
 * @method User                                        setLicenseSt(License $val)                       
 * @method User                                        setLicenseEffective(License $val)                
 * @method User                                        setLicenseLatEffective(License $val)             
 * @method User                                        setLicenseStEffective(License $val)              
 * @method User                                        setLicenseKombiEffective(License $val)           
 * @method User                                        setLicenseForm(License $val)                     
 * @method User                                        setClub(Club $val)                               
 * @method User                                        setAssignments(Doctrine_Collection $val)         
 * @method User                                        setAvailabilities(Doctrine_Collection $val)      
 * @method User                                        setChangeEmailRequests(Doctrine_Collection $val) 
 * @method User                                        setSystemGrants(Doctrine_Collection $val)        
 * @method User                                        setDefaultMandator(Mandator $val)                
 * @method User                                        setCountry(Country $val)                         
 * @method User                                        setPrimaryMandator(Mandator $val)                
 * @method User                                        setPersistentSetting(Doctrine_Collection $val)   
 * @method User                                        setRoles(Doctrine_Collection $val)               
 * @method User                                        setAvailableMandators(Doctrine_Collection $val)  
 * @method User                                        setMandatorGrants(Doctrine_Collection $val)      
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseUser extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('users');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('liznr', 'string', 5, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '5',
             ));
        $this->hasColumn('dtvnr', 'string', 11, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '11',
             ));
        $this->hasColumn('title', 'string', 32, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '32',
             ));
        $this->hasColumn('name', 'string', 32, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '32',
             ));
        $this->hasColumn('surname', 'string', 32, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '32',
             ));
        $this->hasColumn('gender', 'string', 1, array(
             'type' => 'string',
             'fixed' => 1,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '1',
             ));
        $this->hasColumn('email', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '64',
             ));
        $this->hasColumn('phone', 'string', 24, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '24',
             ));
        $this->hasColumn('strasse', 'string', 48, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '48',
             ));
        $this->hasColumn('plz', 'string', 12, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '12',
             ));
        $this->hasColumn('ort', 'string', 48, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '48',
             ));
        $this->hasColumn('land', 'int', 4, array(
             'type' => 'int',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('geburtsjahr', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('passwd', 'string', 32, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '32',
             ));
        $this->hasColumn('club_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('license_st_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('license_lat_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('license_effective_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('license_st_effective_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('license_lat_effective_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('license_kombi_effective_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('license_form_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('active', 'integer', 2, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'default' => 3,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '2',
             ));
        $this->hasColumn('lastlogin', 'date', 25, array(
             'type' => 'date',
             'primary' => false,
             'default' => '1970-01-01',
             'notnull' => false,
             'autoincrement' => false,
             'length' => '25',
             ));
        $this->hasColumn('fails', 'integer', 1, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'default' => '0',
             'notnull' => false,
             'autoincrement' => false,
             'length' => '1',
             ));
        $this->hasColumn('activation_code', 'string', 36, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '36',
             ));
        $this->hasColumn('chpw_code', 'string', 36, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '36',
             ));
        $this->hasColumn('registered', 'timestamp', null, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('validated', 'timestamp', null, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('activated', 'timestamp', null, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('bemerkungen', 'string', 255, array(
             'type' => 'string',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '255',
             ));
        $this->hasColumn('mobile', 'string', 24, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '24',
             ));
        $this->hasColumn('default_mandator_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'notnull' => false,
             'primary' => false,
             'length' => '4',
             ));
        $this->hasColumn('esv_check', 'timestamp', null, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('esv_data', 'blob', null, array(
             'type' => 'blob',
             'unsigned' => false,
             'notnull' => false,
             'primary' => false,
             ));
        $this->hasColumn('gdpr_terms_consent', 'timestamp', null, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('gdpr_terms_version', 'integer', 1, array(
             'type' => 'integer',
             'primary' => false,
             'notnull' => true,
             'default' => '1',
             'autoincrement' => false,
             'length' => '1',
             ));
        $this->hasColumn('listing_consent', 'timestamp', null, array(
             'type' => 'timestamp',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             ));
        $this->hasColumn('primary_mandator_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'notnull' => false,
             'primary' => false,
             'length' => '4',
             ));
        $this->hasColumn('last_license_year', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'notnull' => false,
             'primary' => false,
             'length' => '4',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('License as LicenseLat', array(
             'local' => 'license_lat_id',
             'foreign' => 'id'));

        $this->hasOne('License as LicenseSt', array(
             'local' => 'license_st_id',
             'foreign' => 'id'));

        $this->hasOne('License as LicenseEffective', array(
             'local' => 'license_effective_id',
             'foreign' => 'id'));

        $this->hasOne('License as LicenseLatEffective', array(
             'local' => 'license_lat_effective_id',
             'foreign' => 'id'));

        $this->hasOne('License as LicenseStEffective', array(
             'local' => 'license_st_effective_id',
             'foreign' => 'id'));

        $this->hasOne('License as LicenseKombiEffective', array(
             'local' => 'license_kombi_effective_id',
             'foreign' => 'id'));

        $this->hasOne('License as LicenseForm', array(
             'local' => 'license_form_id',
             'foreign' => 'id'));

        $this->hasOne('Club', array(
             'local' => 'club_id',
             'foreign' => 'id'));

        $this->hasMany('Assignment as Assignments', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('Availability as Availabilities', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('ChangeEmailRequest as ChangeEmailRequests', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('SystemGrant as SystemGrants', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasOne('Mandator as DefaultMandator', array(
             'local' => 'default_mandator_id',
             'foreign' => 'id'));

        $this->hasOne('Country', array(
             'local' => 'land',
             'foreign' => 'id'));

        $this->hasOne('Mandator as PrimaryMandator', array(
             'local' => 'primary_mandator_id',
             'foreign' => 'id'));

        $this->hasMany('PersistentSetting', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $this->hasMany('Role as Roles', array(
             'refClass' => 'SystemGrant',
             'local' => 'user_id',
             'foreign' => 'role_id'));

        $this->hasMany('Mandator as AvailableMandators', array(
             'refClass' => 'MandatorGrant',
             'local' => 'user_id',
             'foreign' => 'mandator_id'));

        $this->hasMany('MandatorGrant as MandatorGrants', array(
             'local' => 'id',
             'foreign' => 'user_id'));

        $datetimebehavior0 = new DateTimeBehavior();
        $dtvnummerbehavior0 = new DTVNummerBehavior();
        $timestampable0 = new Doctrine_Template_Timestampable(array(
             'created' => 
             array(
              'disabled' => true,
             ),
             'updated' => 
             array(
              'name' => 'updated_at',
              'type' => 'timestamp',
              'onInsert' => true,
             ),
             ));
        $this->actAs($datetimebehavior0);
        $this->actAs($dtvnummerbehavior0);
        $this->actAs($timestampable0);
    }
}