<?php

/**
 * BaseEvent
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                   $id                                          Type: integer(4), primary key
 * @property string                                $name                                        Type: string(64)
 * @property string                                $datum                                       Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property int                                   $location_id                                 Type: integer(4)
 * @property int                                   $club_id                                     Type: integer(4)
 * @property string                                $bemerkungen                                 Type: string
 * @property int                                   $mandator_id                                 Type: integer(4)
 * @property int                                   $status                                      Type: integer(4), default "0"
 * @property string                                $datum_bis                                   Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property int                                   $external_id                                 Type: int(4)
 * @property Location                              $Location                                    
 * @property Club                                  $Club                                        
 * @property Doctrine_Collection|Assignmentplan[]  $Assignmentplans                             
 * @property Doctrine_Collection|WRTeam[]          $WRTeam                                      
 * @property Mandator                              $Owner                                       
 *  
 * @method int                                     getId()                                      Type: integer(4), primary key
 * @method string                                  getName()                                    Type: string(64)
 * @method string                                  getDatum()                                   Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                                     getLocationId()                              Type: integer(4)
 * @method int                                     getClubId()                                  Type: integer(4)
 * @method string                                  getBemerkungen()                             Type: string
 * @method int                                     getMandatorId()                              Type: integer(4)
 * @method int                                     getStatus()                                  Type: integer(4), default "0"
 * @method string                                  getDatumBis()                                Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                                     getExternalId()                              Type: int(4)
 * @method Location                                getLocation()                                
 * @method Club                                    getClub()                                    
 * @method Doctrine_Collection|Assignmentplan[]    getAssignmentplans()                         
 * @method Doctrine_Collection|WRTeam[]            getWRTeam()                                  
 * @method Mandator                                getOwner()                                   
 *  
 * @method Event                                   setId(int $val)                              Type: integer(4), primary key
 * @method Event                                   setName(string $val)                         Type: string(64)
 * @method Event                                   setDatum(string $val)                        Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method Event                                   setLocationId(int $val)                      Type: integer(4)
 * @method Event                                   setClubId(int $val)                          Type: integer(4)
 * @method Event                                   setBemerkungen(string $val)                  Type: string
 * @method Event                                   setMandatorId(int $val)                      Type: integer(4)
 * @method Event                                   setStatus(int $val)                          Type: integer(4), default "0"
 * @method Event                                   setDatumBis(string $val)                     Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method Event                                   setExternalId(int $val)                      Type: int(4)
 * @method Event                                   setLocation(Location $val)                   
 * @method Event                                   setClub(Club $val)                           
 * @method Event                                   setAssignmentplans(Doctrine_Collection $val) 
 * @method Event                                   setWRTeam(Doctrine_Collection $val)          
 * @method Event                                   setOwner(Mandator $val)                      
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEvent extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('events');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('name', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '64',
             ));
        $this->hasColumn('datum', 'date', 25, array(
             'type' => 'date',
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '25',
             ));
        $this->hasColumn('location_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('club_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('bemerkungen', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '',
             ));
        $this->hasColumn('mandator_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('status', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'notnull' => true,
             'autoincrement' => false,
             'default' => '0',
             'length' => '4',
             ));
        $this->hasColumn('datum_bis', 'date', 25, array(
             'type' => 'date',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '25',
             ));
        $this->hasColumn('external_id', 'int', 4, array(
             'type' => 'int',
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));


        $this->index('events_datum', array(
             'fields' => 
             array(
              0 => 'datum',
             ),
             ));
        $this->index('ix_events_mandator_id_external_id', array(
             'fields' => 
             array(
              0 => 'mandator_id',
              1 => 'external_id',
             ),
             'type' => 'unique',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Location', array(
             'local' => 'location_id',
             'foreign' => 'id'));

        $this->hasOne('Club', array(
             'local' => 'club_id',
             'foreign' => 'id'));

        $this->hasMany('Assignmentplan as Assignmentplans', array(
             'local' => 'id',
             'foreign' => 'event_id'));

        $this->hasMany('WRTeam', array(
             'local' => 'id',
             'foreign' => 'event_id'));

        $this->hasOne('Mandator as Owner', array(
             'local' => 'mandator_id',
             'foreign' => 'id'));

        $datetimebehavior0 = new DateTimeBehavior();
        $this->actAs($datetimebehavior0);
    }
}