<?php

/**
 * BaseCountry
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                             $id                                    Type: integer(4), primary key
 * @property string                          $name                                  Type: string(64)
 * @property string                          $ioc                                   Type: string(3) fixed-size
 * @property string                          $alpha3                                Type: string(3) fixed-size
 * @property bool                            $active                                Type: boolean
 * @property Doctrine_Collection|Club[]      $Vereine                               
 * @property Doctrine_Collection|Location[]  $Locations                             
 * @property Doctrine_Collection|User[]      $Users                                 
 *  
 * @method int                               getId()                                Type: integer(4), primary key
 * @method string                            getName()                              Type: string(64)
 * @method string                            getIoc()                               Type: string(3) fixed-size
 * @method string                            getAlpha3()                            Type: string(3) fixed-size
 * @method bool                              getActive()                            Type: boolean
 * @method Doctrine_Collection|Club[]        getVereine()                           
 * @method Doctrine_Collection|Location[]    getLocations()                         
 * @method Doctrine_Collection|User[]        getUsers()                             
 *  
 * @method Country                           setId(int $val)                        Type: integer(4), primary key
 * @method Country                           setName(string $val)                   Type: string(64)
 * @method Country                           setIoc(string $val)                    Type: string(3) fixed-size
 * @method Country                           setAlpha3(string $val)                 Type: string(3) fixed-size
 * @method Country                           setActive(bool $val)                   Type: boolean
 * @method Country                           setVereine(Doctrine_Collection $val)   
 * @method Country                           setLocations(Doctrine_Collection $val) 
 * @method Country                           setUsers(Doctrine_Collection $val)     
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseCountry extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('countries');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('name', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'notnull' => true,
             'primary' => false,
             'length' => '64',
             ));
        $this->hasColumn('ioc', 'string', 3, array(
             'type' => 'string',
             'fixed' => 1,
             'notnull' => true,
             'primary' => false,
             'length' => '3',
             ));
        $this->hasColumn('alpha3', 'string', 3, array(
             'type' => 'string',
             'fixed' => 1,
             'notnull' => true,
             'primary' => false,
             'length' => '3',
             ));
        $this->hasColumn('active', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             ));


        $this->index('ix_countries_ioc', array(
             'fields' => 
             array(
              0 => 'ioc',
             ),
             'unique' => true,
             ));
        $this->index('ix_countries_alpha3', array(
             'fields' => 
             array(
              0 => 'alpha3',
             ),
             'unique' => true,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('Club as Vereine', array(
             'local' => 'id',
             'foreign' => 'country_id'));

        $this->hasMany('Location as Locations', array(
             'local' => 'id',
             'foreign' => 'land_id'));

        $this->hasMany('User as Users', array(
             'local' => 'id',
             'foreign' => 'land'));
    }
}