<?php

/**
 * MandatorGrant
 *
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class MandatorGrant extends BaseMandatorGrant
{
	const MASK_ADMIN_READ = 1;
	const MASK_PLAN_READ = 2;
	const MASK_ADMIN_WRITE = 4;
	const MASK_PLAN_WRITE = 8;

	public function isAdminRead()
	{
		return $this->isACLSet(self::MASK_ADMIN_READ);
	}

	public function isPlanRead()
	{
		return $this->isACLSet(self::MASK_PLAN_READ);
	}

	public function isAdminWrite()
	{
		return $this->isACLSet(self::MASK_ADMIN_WRITE);
	}

	public function isPlanWrite()
	{
		return $this->isACLSet(self::MASK_PLAN_WRITE);
	}

	private function isACLSet($mask)
	{
		return ($this->mask & $mask) > 0;
	}

	public function adminRead($value)
	{
		if ($value) {
			$this->grantACL(self::MASK_ADMIN_READ);
		} else {
			$this->revokeACL(self::MASK_ADMIN_READ);
		}
	}

	public function planRead($value)
	{
		if ($value) {
			$this->grantACL(self::MASK_PLAN_READ);
		} else {
			$this->revokeACL(self::MASK_PLAN_READ);
		}
	}

	public function adminWrite($value)
	{
		if ($value) {
			$this->grantACL(self::MASK_ADMIN_WRITE);
		} else {
			$this->revokeACL(self::MASK_ADMIN_WRITE);
		}
	}

	public function planWrite($value)
	{
		if ($value) {
			$this->grantACL(self::MASK_PLAN_WRITE);
		} else {
			$this->revokeACL(self::MASK_PLAN_WRITE);
		}
	}

	private function grantACL($mask)
	{
		// only grant if acl is not set
		if (!$this->isACLSet($mask)) {
			$this->mask = $this->mask | $mask; // OR
		}
	}

	private function revokeACL($mask)
	{
		// only revoke if acl is actually set
		if ($this->isACLSet($mask)) {
			$this->mask = $this->mask ^ $mask; // XOR
		}
	}

}