<?php

/**
 * Mandator
 *
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class Mandator extends BaseMandator
{

	/**
	 * Fügt ein neues MandatorGrant-Objekt hinzu oder aktualisiert ein
	 * bestehendes für den User $user gemäss den Berechtigungen $admin_read,
	 * $plan_read, $admin_write und $plan_write. Wenn keine Berechtigungen bei
	 * der Aktualisierung vergeben werden (Bitmaske=0), wird das
	 * zugrundeliegende MandatorGrant-Objekt gelöscht. Neue
	 * MandatorGrant-Objekte ohne Berechtigungen werden nicht hinzugefügt.
	 *
	 * @param User $user Benutzer
	 * @param bool $admin_read Leseberechtigung Verwaltung
	 * @param bool $plan_read Leseberechtigung Planung
	 * @param bool $admin_write Schreibberechtigung Verwaltung
	 * @param bool $plan_write Schreibberechtigung Planung
	 */
	public function addOrReplaceOperator(User $user, $admin_read = false,
	                                     $plan_read = false, $admin_write = false, $plan_write = false)
	{
		$mg = $this->findMandatorGrant($user);
		$add = false;
		if ($mg == null) {
			$mg = new MandatorGrant();
			$mg->User = $user;
			$mg->mask = 0;
			$add = true;
		}
		$mg->adminRead($admin_read);
		$mg->planRead($plan_read);
		$mg->adminWrite($admin_write);
		$mg->planWrite($plan_write);
		if ($add) {
			if ($mg->mask != 0) {
				$this->MandatorGrants->add($mg);
			}
		} else {
			if ($mg->mask == 0) {
				$this->removeOperator($user);
			}
		}
	}

	public function removeOperator(User $user)
	{
		foreach ($this->MandatorGrants as $idx => $mg) {
			if ($mg->User->id == $user->id) {
				$this->MandatorGrants->remove($idx);
				foreach ($this->Operators as $idx2 => $op) {
					if ($op->id == $user->id) {
						$this->Operators->remove($idx2);
					}
				}
			}
		}
	}

	public function isOperatedBy(User $user)
	{
		$mg = $this->findMandatorGrant($user);
		return $mg != null && $mg->mask != 0;
	}

	public function isOperatedByUserWithACL(User $user, $admin_read = null,
	                                        $plan_read = null, $admin_write = null, $plan_write = null)
	{
		$mg = $this->findMandatorGrant($user);

		if ($mg == null) {
			return false;
		}

		$admin_read_ok = true;
		$plan_read_ok = true;
		$admin_write_ok = true;
		$plan_write_ok = true;

		if ($admin_read != null && $admin_read != false) {
			$admin_read_ok = $mg->isAdminRead();
		}
		if ($plan_read != null && $plan_read != false) {
			$plan_read_ok = $mg->isPlanRead();
		}
		if ($admin_write != null && $admin_write != false) {
			$admin_write_ok = $mg->isAdminWrite();
		}
		if ($plan_write != null && $plan_write != false) {
			$plan_write_ok = $mg->isPlanWrite();
		}

		return $admin_read_ok && $plan_read_ok
		&& $admin_write_ok && $plan_write_ok;
	}

	private function findMandatorGrant(User $user)
	{
		foreach ($this->MandatorGrants as $mg) {
			if ($mg->User->id == $user->id) {
				return $mg;
			}
		}
		return null;
	}

}