<?php

/**
 * Event
 *
 * @package    models
 * @subpackage doctrine
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class Event extends BaseEvent
{

	const STATUS_DEFAULT = 0;
	const STATUS_CANCELLED = -1;

	private $__event_locked;

	public function addWRTeam(WRTeam $wrteam, $saveTeam = true)
	{
		$wrteam->Event = $this;
		$wrteam->date_from = $this->datum;
		if ($saveTeam) {
			$wrteam->save();
		}
		$this->WRTeam->add($wrteam);
		return $wrteam;
	}

	public function getLatestCancellationTime()
	{
		$term = \ZWE\Settings\SettingsRegistry::getInstance()->get('zwe_cancellation_period')->getMandatorValue($this->Owner->id);
		return date_create(strftime('%Y-%m-%d %H:%M:%S', strtotime("-${term} day", $this->getDateTimeObject('datum')->format('U'))));
	}

	public function getTeamCount()
	{
		return $this->WRTeam->count();
	}

	/**
	 * @return bool
	 */
	public function hasValidAssignmentplan()
	{
		if ($this->Assignmentplans != null && $this->Assignmentplans->count() > 0) {
			$ret = false;
			foreach ($this->Assignmentplans as $assignmentplan) {
				$ret = $ret | $assignmentplan->isValidAssignmentPlan();
			}
			return $ret > 0;
		}
		return false;
	}

	public function invalidateAssignmentplans($saveAssignmentplans = true)
	{
		if ($this->Assignmentplans != null && $this->Assignmentplans->count() > 0) {
			foreach ($this->Assignmentplans as $assignmentplan) {
				$assignmentplan->setValid(false);
				if ($saveAssignmentplans) {
					$assignmentplan->save();
				}
			}
		}
	}

	public function isCancellationPossible()
	{
		$now = new DateTime();
		return $now->format('U') <= $this->getLatestCancellationTime()->format('U') ? true : false;
	}

	public function isCancelled()
	{
		return intval($this->status) === self::STATUS_CANCELLED;
	}

	/**
	 * @return bool
	 */
	public function isComplete()
	{
		if ($this->WRTeam != null && $this->WRTeam->count() > 0) {
			$ret = true;
			foreach ($this->WRTeam as $team) {
				$ret = $ret & $team->isComplete();
			}
			return $ret > 0;
		}
		return false;
	}

	public function isInUse()
	{
		return $this->getTeamCount() > 0;
	}

	/**
	 * @return bool
	 */
	public function isInvited()
	{
		if ($this->WRTeam != null && $this->WRTeam->count() > 0) {
			$ret = true;
			foreach ($this->WRTeam as $team) {
				$ret = $ret & $team->isInvited();
			}
			return $ret > 0;
		}
		return false;
	}

	public function isLocked()
	{
		if ($this->__event_locked == null) {
			$this->__event_locked = false;
			if ($this->WRTeam != null) {
				foreach ($this->WRTeam as $team) {
					if ($team->getEinsatzCount(array(Assignment::STATE_INVITED, Assignment::STATE_CONFIRMED)) > 0) {
						$this->__event_locked = true;
					}
				}
			}
		}
		return $this->__event_locked;
	}

	public function isWorkday()
	{
		if ($this->datum != null) {
			return \ZWE\DateUtils::isWorkday($this->getDateTimeObject('datum'));
		}
		return false;
	}

	public function removeWRTeam(WRTeam $team)
	{
		if ($this->WRTeam != null) {
			foreach ($this->WRTeam as $i => $t) {
				if ($team->id == $t->id) {
					$this->WRTeam->remove($i);
					$team->delete();
				}
			}
		}
	}

	public function getAvailableCompetitionDates(): array
	{
		if (!$this->datum) {
			return [];
		}

		if ($this->datum_bis) {
			return \ZWE\calculateAllDatesInRange($this->getDateTimeObject('datum'), $this->getDateTimeObject('datum_bis'));
		} else {
			return \ZWE\calculateAllDatesInRange($this->getDateTimeObject('datum'));
		}
	}

	public function formatDate($format = 'd.m.Y', $dash = '&ndash;'): string
	{
		if ($this->datum_bis) {
			return "{$this->getDateTimeObject('datum')->format($format)} – {$this->getDateTimeObject('datum_bis')->format($format)}";
		} else {
			return $this->getDateTimeObject('datum')->format($format);
		}
	}

	public function getDisplayTitle(): string
	{
		if ($this->datum) {
			$infix = $this->datum_bis ? 'vom' : 'am';
			return "{$this->name} {$infix} {$this->formatDate()}";
		} else {
			return $this->name;
		}
	}

	public function isSingleDayEvent(): bool
	{
		if ($this->datum_bis) {
			return $this->datum_bis === $this->datum;
		} else {
			return true;
		}
	}
}
