<?php

class DateTimeBehavior extends Doctrine_Template
{

	public function getDateTimeObject($property)
	{
		$value = $this->getInvoker()->get($property);
		if ($value != null) {
			if ($value == '0000-00-00') {
				return new DateTime('01-01-1970');
			}
			return new DateTime($value);
		}
		return NULL;
	}

	public function setDateTimeObject($property, $value)
	{
		if ($value !== null) {
			if ($value instanceof DateTime) {
				$this->getInvoker()->set($property, $value->format('Y-m-d H:i:s'));
			} else {
				throw new InvalidArgumentException("Value must be instance of DateTime!");
			}
		} else {
			$this->getInvoker()->set($property, null);
		}
	}

}