<?php

class DTVNummerBehavior extends Doctrine_Template
{

	public function getAsDTVNummer($property)
	{
		$value = $this->getInvoker()->get($property);
		if ($value != null) {
			return \ZWE\ESV\DTVNummer::fromString($value);
		}
	}

	public function setDTVNummer($property, $value)
	{
		if ($value !== null) {
			if ($value instanceof \ZWE\ESV\DTVNummer) {
				$this->getInvoker()->set($property, $value->__toString());
			} else {
				throw new InvalidArgumentException("Value must be instance of DTVNummer!");
			}
		} else {
			$this->getInvoker()->set($property, null);
		}
	}

}