<?php

/**
 * Competition
 *
 * @package    models
 * @subpackage doctrine
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class Competition extends BaseCompetition
{

	public function getBezeichnung()
	{
		return implode(' ', array_merge(
			$this->Discipline->team_typ_default ? [] : [$this->Discipline->name],
			[$this->Startgroup->name, $this->Startclass->name, $this->Dancetype->name],
			$this->dance ? [$this->dance] : []
		));
	}

	public function getLabel()
	{
		return \ZWE\StringUtils::formatIfNull('', '%s ', $this->Startgroup->name) . \ZWE\StringUtils::formatIfNull('', '%s ', $this->Startclass->name)
		. \ZWE\StringUtils::formatIfNull('', '%s', $this->Dancetype->name);
	}

	public function getLongLabel()
	{
		return $this->getLabel() . \ZWE\StringUtils::formatIfNull('', ' (%s)', $this->bemerkung);
	}

	public function formatDate($format = 'd.m.Y'): string
	{
		if ($this->date_to) {
			return "{$this->getDateTimeObject('date_from')->format($format)} – {$this->getDateTimeObject('date_to')->format($format)}";
		} else {
			return $this->getDateTimeObject('date_from')->format($format);
		}
	}
}
