<?php

use function ZWE\count_safe;

/**
 * Club
 *
 * @package    models
 * @subpackage doctrine
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class Club extends BaseClub
{

	/**
	 * Gibt die Anzahl der Veranstaltungen dieses Clubs zurück,
	 * @return int
	 */
	public function getEventCount()
	{
		return count_safe($this->events);
	}

	/**
	 * Gibt die Anzahl der zu diesem Club gehörenden Benutzer zurück.
	 * @return int
	 */
	public function getUserCount()
	{
		return count_safe($this->Users);
	}

	/**
	 * Gibt die Flags (A=ist Ausrichter,W=hat Wertungsrichter) als String zurück, z.B. A-
	 * @return string
	 */
	public function getFlagsAsString()
	{
		$flags = '';
		if ($this->ausrichter <= 0) {
			$flags .= '-';
		} else {
			$flags .= 'A';
		}
		if ($this->has_wr <= 0) {
			$flags .= '-';
		} else {
			$flags .= 'W';
		}
		return $flags;
	}

	/**
	 * Gibt zurück, ob der Club Wertungsrichter hat. Diese Eigenschaft ist unabhängig von
	 * der Anzahl der im System registrierten Benutzer; sie dient zur Einschränkung der
	 * Anzeige bei der Registrierung.
	 * @return boolean
	 */
	public function hasWR()
	{
		return $this->has_wr <= 0 ? false : true;
	}

	/**
	 * Gibt zurück, ob der Club Ausrichter von Turnieren ist.
	 * @return boolean
	 */
	public function isAusrichter()
	{
		return $this->ausrichter <= 0 ? false : true;
	}

	/**
	 * Gibt zurück, ob der Club ein auswärtiger Club ist.
	 * @return boolean
	 */
	public function isAuswaertig()
	{
		return $this->auswaertig <= 0 ? false : true;
	}

	/**
	 * Gibt zurück, ob der Club in Veranstaltungen verwendet wird oder Benutzer hat.
	 * @return boolean
	 */
	public function isInUse()
	{
		return ($this->getEventCount() > 0 || $this->getUserCount() > 0) ? true : false;
	}

}