<?php

/**
 * ChangeEmailRequest
 *
 * @package    models
 * @subpackage doctrine
 * @author     Hendrik Heneke <hendrik@pixelwunder.net>
 */
class ChangeEmailRequest extends BaseChangeEmailRequest
{

	public static function newInstance(User $user, $email, $save = true)
	{
		$request = new ChangeEmailRequest();
		$uuid = new \ZWE\UUID();
		$request->User = $user;
		$request->email = $email;
		$request->setDateTimeObject('requested', new DateTime());
		$request->validation_code = $uuid->generate();
		// @codeCoverageIgnoreStart
		if($save) {
			$request->save();
		}
		// @codeCoverageIgnoreEnd
		return $request;
	}

}