<?php

class Version80 extends Doctrine_Migration_Base
{
	public function up()
	{
		/**
		 * @var $conn Doctrine_Connection
		 */
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		$conn->beginTransaction();
		try {
			$this->dropForeignKeys();

			$dbh = Doctrine_Manager::getInstance()->getCurrentConnection()->getDbh();
			$dbh->exec("SET SESSION sql_mode = ''");
			$dbh->exec("UPDATE users SET lastlogin = '1970-01-01' WHERE lastlogin = '0000-00-00'");

			$this->changeColumn('users', 'lastlogin', 'date', '25', array(
				'primary' => '',
				'default' => '1970-01-01',
				'notnull' => '',
				'autoincrement' => '',
			));

			$this->changeColumn('assignments', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('assignments', 'team_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('assignmentplans', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('assignmentplans', 'event_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('clubs', 'mandator_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('competitions', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('competitions', 'team_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_nummer_sequenz', 'letzte_nummer', 'integer', '4', array(
				'unsigned' => '',
				'notnull' => '1',
			));
			$this->changeColumn('dtv_ver', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrl', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrl', 'vnum', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrm', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('dtv_wrm', 'pnum', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrm', 'jahr', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '',
				'autoincrement' => '',
			));
			$this->changeColumn('events', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('events', 'mandator_id', 'integer', '4', array(
				'unsigned' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('events', 'status', 'integer', '4', array(
				'unsigned' => '',
				'notnull' => '1',
				'autoincrement' => '',
				'default' => '0',
			));
			$this->changeColumn('licenses', 'prio', 'integer', '2', array(
				'unsigned' => '',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
				'default' => '255',
			));
			$this->changeColumn('ltv', 'default_mandator_id', 'integer', '4', array(
				'unsigned' => '',
				'notnull' => '1',
			));
			$this->changeColumn('locations', 'mandator_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('mandators', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('mandator_grants', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('mandator_grants', 'mandator_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
			));
			$this->changeColumn('mandator_grants', 'mask', 'integer', '2', array(
				'unsigned' => '',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
				'default' => '0',
			));
			$this->changeColumn('settings', 'mandator_id', 'integer', '4', array(
				'unsigned' => '',
				'notnull' => '',
			));
			$this->changeColumn('roles', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('system_grants', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('system_grants', 'role_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
			));
			$this->changeColumn('users', 'default_mandator_id', 'integer', '4', array(
				'unsigned' => '',
				'notnull' => '',
				'primary' => '',
			));
			$this->changeColumn('wrteams', 'id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('wrteams', 'event_id', 'integer', '4', array(
				'unsigned' => '',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));

			$this->createForeignKeys();

			$conn->commit();
		} catch (Exception $ex) {
			$conn->rollback();
			throw $ex;
		}
	}

	public function down()
	{
		/**
		 * @var $conn Doctrine_Connection
		 */
		$conn = Doctrine_Manager::getInstance()->getCurrentConnection();
		$conn->beginTransaction();

		try {
			$this->dropForeignKeys();

			$this->changeColumn('assignments', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('assignments', 'team_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('assignmentplans', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('assignmentplans', 'event_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('clubs', 'mandator_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('competitions', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('competitions', 'team_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_nummer_sequenz', 'letzte_nummer', 'integer', '4', array(
				'unsigned' => '1',
				'notnull' => '1',
			));
			$this->changeColumn('dtv_ver', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrl', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrl', 'vnum', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrm', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('dtv_wrm', 'pnum', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('dtv_wrm', 'jahr', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '',
				'autoincrement' => '',
			));
			$this->changeColumn('events', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('events', 'mandator_id', 'integer', '4', array(
				'unsigned' => '1',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('events', 'status', 'integer', '4', array(
				'unsigned' => '1',
				'notnull' => '1',
				'autoincrement' => '',
				'default' => '0',
			));
			$this->changeColumn('licenses', 'prio', 'integer', '1', array(
				'unsigned' => '1',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
				'default' => '255',
			));
			$this->changeColumn('ltv', 'default_mandator_id', 'integer', '4', array(
				'unsigned' => '1',
				'notnull' => '1',
			));
			$this->changeColumn('locations', 'mandator_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));
			$this->changeColumn('mandators', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('mandator_grants', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('mandator_grants', 'mandator_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
			));
			$this->changeColumn('mandator_grants', 'mask', 'integer', '2', array(
				'unsigned' => '1',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
				'default' => '0',
			));
			$this->changeColumn('settings', 'mandator_id', 'integer', '4', array(
				'unsigned' => '1',
				'notnull' => '',
			));
			$this->changeColumn('roles', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('system_grants', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('system_grants', 'role_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'autoincrement' => '',
				'notnull' => '1',
			));
			$this->changeColumn('users', 'default_mandator_id', 'integer', '4', array(
				'unsigned' => '1',
				'notnull' => '',
				'primary' => '',
			));
			$this->changeColumn('wrteams', 'id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '1',
				'autoincrement' => '1',
			));
			$this->changeColumn('wrteams', 'event_id', 'integer', '4', array(
				'unsigned' => '1',
				'primary' => '',
				'notnull' => '1',
				'autoincrement' => '',
			));

			$this->createForeignKeys();

			$conn->commit();
		} catch (Exception $ex) {
			$conn->rollback();
			throw $ex;
		}
	}

	private function dropForeignKeys()
	{
		$this->dropForeignKey('assignments', 'assignments_team_id_wrteams_id');
		$this->dropForeignKey('assignmentplans', 'assignmentplans_event_id_events_id');
		$this->dropForeignKey('clubs', 'clubs_mandator_id_mandators_id');
		$this->dropForeignKey('competitions', 'competitions_team_id_wrteams_id');
		$this->dropForeignKey('dtv_wrl', 'dtv_wrl_vnum_dtv_ver_id');
		$this->dropForeignKey('dtv_wrm', 'dtv_wrm_pnum_dtv_wrl_id');
		$this->dropForeignKey('events', 'events_mandator_id_mandators_id');
		$this->dropForeignKey('ltv', 'ltv_default_mandator_id_mandators_id');
		$this->dropForeignKey('locations', 'locations_mandator_id_mandators_id');
		$this->dropForeignKey('mandator_grants', 'mandator_grants_mandator_id_mandators_id');
		$this->dropForeignKey('settings', 'settings_mandator_id_mandators_id');
		$this->dropForeignKey('system_grants', 'system_grants_role_id_roles_id');
		$this->dropForeignKey('users', 'users_default_mandator_id_mandators_id');
		$this->dropForeignKey('wrteams', 'wrteams_event_id_events_id');
	}

	private function createForeignKeys()
	{
		$this->createForeignKey('assignments', 'assignments_team_id_wrteams_id', array(
			'name' => 'assignments_team_id_wrteams_id',
			'local' => 'team_id',
			'foreign' => 'id',
			'foreignTable' => 'wrteams',
			'onUpdate' => NULL,
			'onDelete' => 'CASCADE',
		));
		$this->createForeignKey('assignmentplans', 'assignmentplans_event_id_events_id', array(
			'name' => 'assignmentplans_event_id_events_id',
			'local' => 'event_id',
			'foreign' => 'id',
			'foreignTable' => 'events',
		));
		$this->createForeignKey('clubs', 'clubs_mandator_id_mandators_id', array(
			'name' => 'clubs_mandator_id_mandators_id',
			'local' => 'mandator_id',
			'foreign' => 'id',
			'foreignTable' => 'mandators',
		));
		$this->createForeignKey('competitions', 'competitions_team_id_wrteams_id', array(
			'name' => 'competitions_team_id_wrteams_id',
			'local' => 'team_id',
			'foreign' => 'id',
			'foreignTable' => 'wrteams',
			'onUpdate' => NULL,
			'onDelete' => 'CASCADE',
		));
		$this->createForeignKey('dtv_wrl', 'dtv_wrl_vnum_dtv_ver_id', array(
			'name' => 'dtv_wrl_vnum_dtv_ver_id',
			'local' => 'vnum',
			'foreign' => 'id',
			'foreignTable' => 'dtv_ver',
		));
		$this->createForeignKey('dtv_wrm', 'dtv_wrm_pnum_dtv_wrl_id', array(
			'name' => 'dtv_wrm_pnum_dtv_wrl_id',
			'local' => 'pnum',
			'foreign' => 'id',
			'foreignTable' => 'dtv_wrl',
		));
		$this->createForeignKey('events', 'events_mandator_id_mandators_id', array(
			'name' => 'events_mandator_id_mandators_id',
			'local' => 'mandator_id',
			'foreign' => 'id',
			'foreignTable' => 'mandators',
		));
		$this->createForeignKey('ltv', 'ltv_default_mandator_id_mandators_id', array(
			'name' => 'ltv_default_mandator_id_mandators_id',
			'local' => 'default_mandator_id',
			'foreign' => 'id',
			'foreignTable' => 'mandators',
		));
		$this->createForeignKey('locations', 'locations_mandator_id_mandators_id', array(
			'name' => 'locations_mandator_id_mandators_id',
			'local' => 'mandator_id',
			'foreign' => 'id',
			'foreignTable' => 'mandators',
		));
		$this->createForeignKey('mandator_grants', 'mandator_grants_mandator_id_mandators_id', array(
			'name' => 'mandator_grants_mandator_id_mandators_id',
			'local' => 'mandator_id',
			'foreign' => 'id',
			'foreignTable' => 'mandators',
		));
		$this->createForeignKey('settings', 'settings_mandator_id_mandators_id', array(
			'name' => 'settings_mandator_id_mandators_id',
			'local' => 'mandator_id',
			'foreign' => 'id',
			'foreignTable' => 'mandators',
		));
		$this->createForeignKey('system_grants', 'system_grants_role_id_roles_id', array(
			'name' => 'system_grants_role_id_roles_id',
			'local' => 'role_id',
			'foreign' => 'id',
			'foreignTable' => 'roles',
		));
		$this->createForeignKey('users', 'users_default_mandator_id_mandators_id', array(
			'name' => 'users_default_mandator_id_mandators_id',
			'local' => 'default_mandator_id',
			'foreign' => 'id',
			'foreignTable' => 'mandators',
		));
		$this->createForeignKey('wrteams', 'wrteams_event_id_events_id', array(
			'name' => 'wrteams_event_id_events_id',
			'local' => 'event_id',
			'foreign' => 'id',
			'foreignTable' => 'events',
		));
	}
}