<?php
/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class Version50 extends Doctrine_Migration_Base
{
	public function up()
	{
		$this->createTable('ltv', array(
			'id' =>
				array(
					'type' => 'string',
					'fixed' => '0',
					'primary' => '1',
					'length' => '12',
				),
			'name' =>
				array(
					'type' => 'string',
					'fixed' => '0',
					'notnull' => '1',
					'length' => '48',
				),
			'public' =>
				array(
					'type' => 'boolean',
					'notnull' => '1',
					'length' => '25',
				),
		), array(
			'primary' =>
				array(
					0 => 'id',
				),
			'collate' => 'utf8_general_ci',
			'charset' => 'utf8',
		));
	}

	public function down()
	{
		$this->dropTable('ltv');
	}

	public function postUp()
	{
		// nur produktive datenbanken
		if ($this->isProductionDatabase()) {
			$ltv = array(
				'_none_' => '(kein)',
				'EXT' => 'Ausland',
				'TBW' => 'Tanzsportverband Baden-Württemberg',
				'Bayern' => 'Landestanzsportverband Bayern',
				'Berlin' => 'Landestanzsportverband Berlin',
				'Bremen' => 'Landestanzsportverband Bremen',
				'HATV' => 'Hamburger Tanzsportverband',
				'HTV' => 'Hessischer Tanzsportverband',
				'NTV' => 'Niedersächsischer Tanzsportverband',
				'TNW' => 'Tanzsportverband Nordrhein-Westfalen',
				'TRP' => 'Tanzsportverband Rheinland-Pfalz',
				'SLT' => 'Saarländischer Landesverband für Tanzsport',
				'TSH' => 'Tanzsportverband Schleswig-Holstein',
				'LTV Br' => 'Landestanzsportverband Brandenburg',
				'TMV' => 'Tanzsportverband Mecklenburg-Vorpommern',
				'TVS' => 'Landestanzsportverband Sachsen',
				'TVSA' => 'Landestanzsportverband Sachsen-Anhalt',
				'TTSV' => 'Thüringischer Tanzsportverband'
			);
			foreach ($ltv as $id => $name) {
				$public = true;
				if ($id == '_none_') {
					$public = false;
				}
				$l = new LTV();
				$l->id = $id;
				$l->name = $name;
				$l->public = $public;
				$l->save();
			}
		}
	}

	private function isProductionDatabase()
	{
		$pdo = Doctrine_Manager::getInstance()->getCurrentConnection()->getDbh();
		$stmt = $pdo->prepare("SELECT COUNT(*) FROM users");
		$stmt->execute();
		return $stmt->fetchColumn(0) > 0;
	}
}