<?php
/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class Version37 extends Doctrine_Migration_Base
{
	public function up()
	{
		$this->createForeignKey('system_grants', 'system_grants_user_id_users_id', array(
			'name' => 'system_grants_user_id_users_id',
			'local' => 'user_id',
			'foreign' => 'id',
			'foreignTable' => 'users',
		));
		$this->createForeignKey('system_grants', 'system_grants_role_id_roles_id', array(
			'name' => 'system_grants_role_id_roles_id',
			'local' => 'role_id',
			'foreign' => 'id',
			'foreignTable' => 'roles',
		));
		$this->addIndex('system_grants', 'system_grants_user_id', array(
			'fields' =>
				array(
					0 => 'user_id',
				),
		));
		$this->addIndex('system_grants', 'system_grants_role_id', array(
			'fields' =>
				array(
					0 => 'role_id',
				),
		));
	}

	public function down()
	{
		$this->dropForeignKey('system_grants', 'system_grants_user_id_users_id');
		$this->dropForeignKey('system_grants', 'system_grants_role_id_roles_id');
		$this->removeIndex('system_grants', 'system_grants_user_id', array(
			'fields' =>
				array(
					0 => 'user_id',
				),
		));
		$this->removeIndex('system_grants', 'system_grants_role_id', array(
			'fields' =>
				array(
					0 => 'role_id',
				),
		));
	}

	public function postDown()
	{
		$c = Doctrine_Manager::getInstance()->getConnectionForComponent("User");
		$dbh = $c->getDbh();
		$dbh->exec('DELETE FROM roles');
		$dbh->exec('DELETE FROM system_grants');
	}

	public function postUp()
	{
		// nur für produktive datenbanken
		if ($this->isProductionDatabase()) {
			$new_roles = array(
				array('role' => 'ROLE_WR', 'description' => 'Wertungsrichter'),
				array('role' => 'ROLE_ZWE', 'description' => 'ZWE'),
				array('role' => 'ROLE_ADMIN', 'description' => 'Administrator')
			);
			$roles = array();
			foreach ($new_roles as $new_role) {
				$r = new Role();
				$r->fromArray($new_role);
				$r->save();
				$roles[$r->role] = $r;
			}

			// alle bisherigen ZWE-Benutzern die Rollen ROLE_ZWE und ROLE_ADMIN zuordnen
			// allen bisherigen WR-Benutzern die Rolle ROLE_WR zuordnen
			// property zwe ist im zweifel nicht mehr vorhanden, daher umsetzung
			// nur auf sql-basis
			$c = Doctrine_Manager::getInstance()->getConnectionForComponent("User");
			$dbh = $c->getDbh();
			$stmt = $dbh->prepare("SELECT * from users");
			$res = $stmt->execute();
			while ($row = $stmt->fetch()) {
				if ($row['zwe'] == 1) {
					$sg1 = new SystemGrant();
					$sg1->Role = $roles['ROLE_ZWE'];
					$sg1->user_id = $row['id'];
					$sg1->save();
					$sg2 = new SystemGrant();
					$sg2->Role = $roles['ROLE_ADMIN'];
					$sg2->user_id = $row['id'];
					$sg2->save();
				} else {
					$sg1 = new SystemGrant();
					$sg1->Role = $roles['ROLE_WR'];
					$sg1->user_id = $row['id'];
					$sg1->save();
				}
			}
		}
	}

	private function isProductionDatabase()
	{
		$pdo = Doctrine_Manager::getInstance()->getCurrentConnection()->getDbh();
		$stmt = $pdo->prepare("SELECT COUNT(*) FROM users");
		$stmt->execute();
		return $stmt->fetchColumn(0) > 0;
	}
}