<?php
/**
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class Version35 extends Doctrine_Migration_Base
{
	public function up()
	{
		$this->removeIndex('licenses', 'ix_license_type_prio', array(
			'fields' =>
				array(
					0 => 'prio',
				),
			'type' => 'unique',
		));
		$this->addIndex('licenses', 'ix_license_type_prio', array(
			'fields' =>
				array(
					1 => 'type',
					0 => 'prio',
				),
			'type' => 'unique',
		));
	}

	public function postUp()
	{
		// nur für produktive datenbanken
		if ($this->isProductionDatabase()) {
			$new = array(
				array('name' => 'F1-Lizenz', 'shortname' => 'F1', 'type' => 'F', 'enabled' => 1, 'effective' => 0, 'sortorder' => 3, 'builtin' => 1, 'prio' => 1),
				array('name' => 'F2-Lizenz', 'shortname' => 'F2', 'type' => 'F', 'enabled' => 1, 'effective' => 0, 'sortorder' => 2, 'builtin' => 1, 'prio' => 2),
				array('name' => 'keine', 'shortname' => '-', 'type' => 'F', 'enabled' => 1, 'effective' => 0, 'sortorder' => 1, 'builtin' => 1, 'prio' => 255),
			);
			foreach ($new as $n) {
				$l = new License();
				$l->fromArray($n);
				$l->save();
			}
		}
	}

	public function preDown()
	{
		$query = Doctrine_Query::create()
			->select('l.*')
			->from('License l')
			->where('l.type = ?', License::TYPE_FORMATION);
		foreach ($query->execute() as $l) {
			$l->delete();
		}
	}

	public function down()
	{
		$this->removeIndex('licenses', 'ix_license_type_prio', array(
			'fields' =>
				array(
					1 => 'type',
					0 => 'prio',
				),
			'type' => 'unique',
		));
		$this->addIndex('licenses', 'ix_license_type_prio', array(
			'fields' =>
				array(
					0 => 'prio',
				),
			'type' => 'unique',
		));
	}

	private function isProductionDatabase()
	{
		$pdo = Doctrine_Manager::getInstance()->getCurrentConnection()->getDbh();
		$stmt = $pdo->prepare("SELECT COUNT(*) FROM users");
		$stmt->execute();
		return $stmt->fetchColumn(0) > 0;
	}
}