<?php
declare(strict_types=1);

namespace ZWE;

/**
 * Counts array or \Countable, returns 0 if value is not an array or a \Countable
 * @param mixed $value
 * @return int
 */
function count_safe($value): int
{
	if (is_array($value)) {
		return count($value);
	} elseif (interface_exists('\Countable') && $value instanceof \Countable) {
		return count($value);
	} else {
		return 0;
	}
}

function calculateAllDatesInRange(\DateTime $from, ?\DateTime $to = null): array
{
	if ($to) {
		$start = \Carbon\Carbon::instance($from);
		$end = \Carbon\Carbon::instance($to);
		if ($end->isBefore($start)) {
			throw new \InvalidArgumentException('End of date range is before start of range!');
		}
		$return = [];
		while ($start->isBefore($end) || $start->eq($end)) {
			$return[$start->format('Y-m-d')] = $start->format('d.m.Y');
			$start = $start->addDay();
		}
		return $return;
	} else {
		return [
			$from->format('Y-m-d') => $from->format('d.m.Y')
		];
	}
}

function removeSpecialChars($input): string
{
	return str_replace(['–'], ['-'], $input);
}
