<?php
namespace ZWE\Validation\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use ZWE\Container\ZWEApplicationContainerImpl;

class UniqueDTVNummerValidator extends ConstraintValidator
{

	public function validate($value, Constraint $constraint)
	{
		if (trim($value) == '') {
			return true;
		}

		if (ZWEApplicationContainerImpl::getInstance()->getUserRepo()->findByDTVNummer($value) != null) {
			$this->context->buildViolation($constraint->message)
				->setParameter('%dtvId%', $value)
				->addViolation();
		}
	}

}