<?php
namespace ZWE\Repository;

class StartgroupRepository extends AbstractRepository
{

	/**
	 * @param $id
	 * @return \Startgroup
	 */
	public function find($id)
	{
		return $this->findInternal('Startgroup', $id);
	}

	/**
	 * @param bool $onlyEnabled
	 * @return array
	 */
	public function getAllNames($onlyEnabled = true)
	{
		$query = \Doctrine_Query::create()
			->select('s.id, s.name')
			->from('Startgroup s')
			->orderBy('s.name')
			->setHydrationMode(\Doctrine::HYDRATE_ARRAY);
		if ($onlyEnabled) {
			$query->addWhere('s.enabled = ?', true);
		}
		return $this->toSingleDimension($query->execute(), 'id', 'name');
	}

	/**
	 * @param bool $onlyEnabled
	 * @return \Doctrine_Collection
	 */
	public function getAll($onlyEnabled = false)
	{
		$query = \Doctrine_Query::create()
			->select('s.*, c.*')
			->from('Startgroup s')
			->leftJoin('s.Competitions c')
			->orderBy('s.name');
		if ($onlyEnabled) {
			$query->addWhere('s.enabled = ?', true);
		}
		return $query->execute();
	}

}
