<?php
namespace ZWE\Repository;

class RoleRepository extends AbstractRepository
{

	private $roles;

	public function getByRolename($rolename)
	{
		if ($this->roles == null) {
			$this->loadAllRoles();
		}
		if (isset($this->roles[$rolename])) {
			return $this->roles[$rolename];
		}
		throw new ObjectNotFoundException('Die Rolle ' . $rolename . ' existiert nicht');
	}

	private function loadAllRoles()
	{
		$query = \Doctrine_Query::create()
			->select('r.*')
			->from('Role r');
		$result = $query->execute();
		$this->roles = array();
		foreach ($result as $r) {
			$this->roles[$r->role] = $r;
		}
	}

}