<?php
namespace ZWE\Repository;

use function ZWE\count_safe;

class LocationRepository extends AbstractRepository
{

	/**
	 * @param $id
	 * @return \Location
	 */
	public function find($id)
	{
		return $this->findInternal('Location', $id);
	}

	/**
	 * @return array
	 */
	public function getAllNames()
	{
		$query = \Doctrine_Query::create()
			->select('l.id, l.name')
			->from('Location l')
			->orderBy('l.name')
			->setHydrationMode(\Doctrine::HYDRATE_ARRAY);
		return $this->toSingleDimension($query->execute(), 'id', 'name');
	}

	/**
	 * @param int $page
	 * @param int $maxPerPage
	 * @param string $search
	 * @param string $sortname
	 * @param string $sortorder
	 * @param null $owners
	 * @return \Doctrine_Collection
	 */
	public function pagedQuery($page = 1, $maxPerPage = 10, $search = '%', $sortname = 'name', $sortorder = 'ASC', $owners = null)
	{
		return $this->pagedQueryWithPagerResult($page, $maxPerPage, $search, $sortname, $sortorder, $owners)->execute();
	}

	/**
	 * @param int $page
	 * @param int $maxPerPage
	 * @param string $search
	 * @param string $sortname
	 * @param string $sortorder
	 * @param null $owners
	 * @return \Doctrine_Pager
	 */
	public function pagedQueryWithPagerResult($page = 1, $maxPerPage = 10, $search = '%', $sortname = 'name', $sortorder = 'ASC', $owners = null)
	{
		$query = \Doctrine_Query::create()
			->select('l.*')
			->from('Location l')
			->where('l.name LIKE ?', $search)
			->andWhere('l.external_id IS NULL')
			->orderBy("l.{$sortname} {$sortorder}");
		if ($owners != null) {
			$owner_ids = \ZWE\Mandator\MandatorUtils::asIdArray($owners);
			if (count_safe($owner_ids) > 0) {
				$query->andWhereIn('l.mandator_id', $owner_ids);
			}
		}
		return new \Doctrine_Pager($query, $page, $maxPerPage);
	}
}
