<?php
namespace ZWE\Repository;

class LTVRepository extends AbstractRepository
{

	/**
	 * @return array
	 */
	public function all()
	{
		$ltvs = $this->queryWithParams();
		$ret = array();
		foreach ($ltvs as $l) {
			$ret[$l->id] = $l->name;
		}
		return $ret;
	}

	/**
	 * @return array
	 */
	public function allPublic()
	{
		$ltvs = self::queryWithParams(true);
		$ret = array();
		foreach ($ltvs as $l) {
			$ret[$l->id] = $l->name;
		}
		return $ret;
	}

	/**
	 * @return array
	 */
	public function allPublicIds()
	{
		$ltvs = self::queryWithParams(true);
		$ret = array();
		foreach ($ltvs as $l) {
			$ret[$l->id] = $l->id;
		}
		ksort($ret);
		return $ret;
	}

	/**
	 * @param $id
	 * @return \LTV
	 */
	public function find($id)
	{
		return $this->findInternal('LTV', $id);
	}

	/**
	 * @param $key
	 * @return \LTV|null
	 */
	public function findByEsvKey($key)
	{
		$results = $this->queryWithParams(null, $key);
		if($results->count() > 0) {
			return $results[0];
		}
	}

	public function loadByesvKey($key)
	{
		$ltv = $this->findByEsvKey($key);
		if($ltv == null) {
			throw new \RuntimeException("LTV mit ESV-Schlüssel '{$key}' nicht gefunden!");
		}
		return $ltv;
	}

	/**
	 * @param mixed $public
	 * @param string $esv_key
	 * @return \Doctrine_Collection
	 */
	public function queryWithParams($public = null, $esv_key = null)
	{
		$query = \Doctrine_Query::create()
			->from('LTV l')
			->orderBy('l.name');
		if ($public != null) {
			$query->addWhere('l.public = ?', $public);
		}
		if($esv_key != null) {
			$query->addWhere('l.esv_key = ?', $esv_key);
		}
		return $query->execute();
	}

}
