<?php
namespace ZWE\Repository;

class AvailabilityRepository extends AbstractRepository
{

	public function find($id)
	{
		return $this->findInternal('Availability', $id);
	}

	public function getAvailabilitiesByUser(\User $user, $year, $month)
	{
		$sql = "
			SELECT {a.*}, {u.*}
			FROM
				availabilities a
			INNER JOIN
				users u ON a.user_id = u.id
			WHERE
				a.user_id = {$user->id}
		";

		if ($year != NULL) {
			$sql .= "
				AND YEAR(a.datum) = {$year}
			";
		}

		if ($month != NULL) {
			$sql .= "
				AND MONTH(a.datum) = {$month}
			";
		}

		$sql .= "
			ORDER BY
				a.datum
		";

		$query = new \Doctrine_RawSql();
		$query->parseDqlQuery($sql);
		$query->addComponent('a', 'Availability a');
		$query->addComponent('u', 'a.User u');

		return $query->execute();
	}

	public function getAvailabilitiesBetween(\DateTime $from, \DateTime $to = null, $wrMandanten = null, $ltvs = null)
	{
		$query = \Doctrine_Query::create()
			->select('av.*, u.*, c.*, licst.*, liclat.*')
			->from('Availability av')
			->innerJoin('av.User u')
			->innerJoin('u.Club c')
			->innerJoin('u.LicenseStEffective licst')
			->innerJoin('u.LicenseLatEffective liclat')
			->orderBy('av.datum, u.surname, u.name');
		if ($to != null) {
			$query->where('av.datum >= ?', $from->format('Y-m-d'));
			$query->andWhere('av.datum <= ?', $to->format('Y-m-d'));
		} else {
			$query->where('av.datum = ?', $from->format('Y-m-d'));
		}
		if ($wrMandanten != null) {
			$mandantenIds = \ZWE\Mandator\MandatorUtils::asIdArray($wrMandanten);
			$query->andWhereIn('c.mandator_id', $mandantenIds);
		}
		if ($ltvs != null) {
			$ltvIds = $this->landesverbaendeToIdArray($ltvs);
			$query->andWhereIn('c.ltv_id', $ltvIds);
		}
		return $query->execute();
	}
}
