<?php
namespace ZWE\Repository;

class AssignmentRepository extends AbstractRepository
{

	public function find($id)
	{
		return $this->findInternal('Assignment', $id);
	}

	public function getAssignmentsByWRTeam(\WRTeam $team, $state, \User $exclude = null)
	{
		$query = \Doctrine_Query::create()
			->select('a.*, u.*, c.*')
			->from('Assignment a')
			->innerJoin('a.User u')
			->innerJoin('u.Club c')
			->where('a.team_id = ?', $team->id)
			->orderBy('u.surname, u.name');
		if ($state != null) {
			$query->andWhereIn('a.state', $state);
		}
		if ($exclude != null) {
			$query->andWhere('a.user_id <> ?', $exclude->id);
		}
		return $query->execute();
	}

	public function getAssignmentsByUser(\User $user, $year = null, $month = null)
	{
		$sql = "
			SELECT {a.*}, {t.*}, {e.*}
			FROM
				assignments a
			INNER JOIN
				wrteams t ON a.team_id = t.id
			INNER JOIN
				events e ON t.event_id = e.id
			WHERE
				a.user_id = {$user->id}
		";

		if ($year != null) {
			$sql .= "
				AND YEAR(t.date_from) = {$year}
			";
		}

		if ($month != null) {
			$sql .= "
				AND MONTH(t.date_from) = {$month}
			";
		}

		$sql .= "
			ORDER BY
				t.date_from
		";

		$query = new \Doctrine_RawSql();
		$query->parseDqlQuery($sql);
		$query->addComponent('a', 'Assignment a');
		$query->addComponent('t', 'a.WRTeam t');
		$query->addComponent('e', 't.Event e');

		return $query->execute();
	}

	private function getLatestChangesQuery($owners = null)
	{
		$query = \Doctrine_Query::create()
			->select('a.*, IFNULL(a.cancelled, a.confirmed) AS lastchanged, t.*, e.*, u.*')
			->from('Assignment a')
			->innerJoin('a.WRTeam t')
			->innerJoin('t.Event e')
			->innerJoin('a.User u')
			->whereIn('a.state', array(\Assignment::STATE_CONFIRMED, \Assignment::STATE_CANCELLED))
			->orderBy("lastchanged DESC");
		if ($owners != null) {
			$owner_ids = \ZWE\Mandator\MandatorUtils::asIdArray($owners);
			$query->andWhereIn('e.mandator_id', $owner_ids);
		}
		return $query;
	}

	public function getLatestChangesPager($page = 1, $results = 7, $owners = null)
	{
		return new \Doctrine_Pager($this->getLatestChangesQuery($owners),
			$page, $results);
	}

}
