<?php

namespace ZWE\Queue;

use Psr\Log\LoggerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use ZWE\Container\LoggingService;

class SyncQueueDriver implements QueueDriver
{

	/**
	 * @var ValidatorInterface
	 */
	private $validator;

	/**
	 * @var LoggerInterface
	 */
	private $logger;

	public function __construct(ValidatorInterface $validator, LoggingService $loggingService)
	{
		$this->validator = $validator;
		$this->logger = $loggingService->createLogger(SyncQueueDriver::class);
	}

	public function queue(Job $job)
	{
		$violations = $this->validator->validate($job);
		if ($violations->count() > 0) {
			$this->logger->error('job is invalid', ['violations' => $violations]);
			throw new \InvalidArgumentException('Job is invalid!');
		}
		$job->run();
	}

	public function pageJobs($page, $sort = 'id', $order = 'DESC', $size = 10)
	{
		return [];
	}

	public function requeue($id)
	{
	}
}
