<?php

namespace ZWE\Queue;

use Carbon\Carbon;

class QueueWorkerStatistics
{

	const STATE_IDLE = 'idle';
	const STATE_WORKING = 'working';
	const STATE_PAUSED = 'paused';

	/**
	 * @var int
	 */
	public $pid;

	/**
	 * @var Carbon
	 */
	public $startTime;

	/**
	 * @var float
	 */
	public $memoryUsage;

	/**
	 * @var int
	 */
	public $jobsProcessed;

	/**
	 * @var string
	 */
	public $state;

	/**
	 * @var null|int
	 */
	public $currentJob;

	public function __construct($pid, $memoryUsage, $state)
	{
		$this->pid = $pid;
		$this->memoryUsage = $memoryUsage;
		$this->state = $state;
		$this->jobsProcessed = 0;
		$this->currentJob = null;
		$this->startTime = Carbon::now();
	}
}
