<?php

namespace ZWE\Queue;

interface Job extends \Serializable
{

	/**
	 * Returns the job name
	 *
	 * @return string
	 */
	public function getName();

	/**
	 * Runs the job with a callback to check if the job should be interrupted (if possible)
	 *
	 * @param callable|null $shouldStop
	 * @return boolean returns true if the job was completely finished, false if it was interrupted
	 */
	public function run(callable $shouldInterrupt = null);
}
