<?php
namespace ZWE\Mandator;

class MandatorUtils
{

	/**
	 * Extrahiert die IDs aus dem Eingabewert <code>$owners</code> und gibt
	 * sie als Array zurück.
	 *
	 * @param mixed $owners Doctrine_Collection (Mandator), array (Mandator)
	 * oder array (int), Mandator, int
	 * @return array
	 */
	public static function asIdArray($owners)
	{
		$owner_ids = array();
		if (is_a($owners, '\Doctrine_Collection')) {
			foreach ($owners as $o) {
				if (is_a($o, '\Mandator')) {
					$owner_ids[] = $o->id;
				}
			}
		} elseif (is_array($owners)) {
			foreach ($owners as $o) {
				if (is_a($o, '\Mandator')) {
					$owner_ids[] = $o->id;
				} else {
					$owner_ids[] = $o;
				}
			}
		} else {
			if (is_a($owners, '\Mandator')) {
				$owner_ids[] = $owners->id;
			} else {
				$owner_ids[] = $owners;
			}
		}
		return $owner_ids;
	}

}