<?php
namespace ZWE\Mandator;
use ZWE\Context\CISessionContextHolder;

/**
 * ContextHolder, der den aktuellen Mandanten-Kontext in der
 * CodeIgniter-Session speichert.
 *
 * Dabei wird lediglich die Mandanten-ID in der Session gespeichert und das
 * Mandanten-Objekt bei Bedarf aus der Datenbank geladen.
 *
 * @author  Hendrik Heneke <hendrik@pixelwunder.net>
 * @since   2.5
 */
class MandatorCISessionContextHolder extends CISessionContextHolder
{

	private $ms;

	public function __construct()
	{
		parent::__construct();
		$this->ms = new MandatorService();
	}

	protected function getSessionKey()
	{
		return 'ZWE-MANDATOR-ID';
	}

	protected function retrieveFromContext()
	{
		return $this->ms->getMandator($this->retrieveValueFromCISession());
	}

	protected function saveInContext($mandator)
	{
		$this->saveValueInCISession($mandator->id);
	}

}