<?php

namespace ZWE\Mail;

class MessageVariables
{

	/**
	 * @var string
	 */
	private $subjectPrefix;

	/**
	 * @var string
	 */
	private $senderName;

	/**
	 * @var string
	 */
	private $senderAddress;

	/**
	 * @var string
	 */
	private $footerHtml;

	/**
	 * @var string
	 */
	private $zweRecipient;

	/**
	 * @var string
	 */
	private $registrationRecipient;

	/**
	 * @var string
	 */
	private $cancellationRecipient;

	/**
	 * @var $planRecipient
	 */
	private $planRecipient;

	/**
	 * @var bool
	 */
	private $useAdresses;

	/**
	 * @var bool
	 */
	private $useBirthyear;

	/**
	 * @param $subjectPrefix Pr&auml;fix f&uuml;r Nachricht
	 * @param $senderName Absendername
	 * @param $senderAddress Absenderadresse
	 * @param $zweRecipient ZWE-Emp&auml;ngeradresse
	 * @param $registrationRecipient Registrierungs-Empf&auml;ngeradresse
	 * @param $cancellationRecipient Absage-Empf&auml;ngeraddresse
	 * @param $planRecipient Einsatzplan-Empf&auml;ngeraddresse
	 * @param $footerHtml
	 * @param $useAddresses
	 * @param bool $useBirthyear
	 */
	public function __construct($subjectPrefix, $senderName, $senderAddress, $zweRecipient, $registrationRecipient, $cancellationRecipient, $planRecipient, $footerHtml, $useAddresses, $useBirthyear = false)
	{
		$this->subjectPrefix = $subjectPrefix;
		$this->senderName = $senderName;
		$this->senderAddress = $senderAddress;
		$this->zweRecipient = $zweRecipient;
		$this->registrationRecipient = $registrationRecipient;
		$this->cancellationRecipient = $cancellationRecipient;
		$this->planRecipient = $planRecipient;
		$this->footerHtml = $footerHtml;
		$this->useAdresses = $useAddresses;
		$this->useBirthyear = $useBirthyear;
	}

	/**
	 * @return string
	 */
	public function getSubjectPrefix()
	{
		return $this->subjectPrefix;
	}

	/**
	 * @return string
	 */
	public function getSenderName()
	{
		return $this->senderName;
	}

	/**
	 * @return string
	 */
	public function getSenderAddress()
	{
		return $this->senderAddress;
	}

	/**
	 * @return string
	 */
	public function getFooterHtml()
	{
		return $this->footerHtml;
	}

	/**
	 * @param $subject
	 * @return string
	 */
	public function formatSubject($subject)
	{
		return sprintf('%1$s %2$s', $this->subjectPrefix, $subject);
	}

	/**
	 * @return array
	 */
	public function getSenderArray()
	{
		return array($this->senderAddress => $this->senderName);
	}

	/**
	 * @return string
	 */
	public function getZWERecipient()
	{
		return $this->zweRecipient;
	}

	/**
	 * return string
	 */
	public function getRegistrationRecipient()
	{
		if ($this->registrationRecipient != null) {
			return $this->registrationRecipient;
		}
		return $this->zweRecipient;
	}

	/**
	 * @return string
	 */
	public function getCancellationRecipient()
	{
		if ($this->cancellationRecipient != null) {
			return $this->cancellationRecipient;
		}
		return $this->zweRecipient;
	}

	/**
	 * @return string
	 */
	public function getPlanRecipient()
	{
		if ($this->planRecipient != null) {
			return $this->planRecipient;
		}
		return $this->zweRecipient;
	}

	/**
	 * @return bool
	 */
	public function isUseAddresses()
	{
		return $this->useAdresses;
	}

	/**
	 * @return bool
	 */
	public function isUseBirthyear()
	{
		return $this->useBirthyear;
	}
}
