<?php

namespace ZWE\Jobs;

use Symfony\Component\Validator\Constraints as Assert;

class SendValidateNewEmailMailJob extends AbstractSendMailJob
{

	/**
	 * @var \ChangeEmailRequest
	 * @Assert\NotNull()
	 */
	protected $request;

	/**
	 * @return \ChangeEmailRequest
	 */
	public function getRequest()
	{
		return $this->request;
	}

	/**
	 * @param \ChangeEmailRequest $request
	 * @return SendValidateNewEmailMailJob
	 */
	public function setRequest($request)
	{
		$this->request = $request;
		return $this;
	}

	protected function getValuesToSerialize()
	{
		return [
			'requestId' => $this->request->id,
		];
	}

	protected function unserializeInternal($unserializedValues)
	{
		parent::unserializeInternal($unserializedValues);
		$this->request = \Doctrine::getTable(\ChangeEmailRequest::class)->findOneBy('id', $unserializedValues['requestId']);
	}

	public function run(callable $shouldInterrupt = null)
	{
		if ($this->container->getMailingService()->sendValidationNewEmailMessage($this->messageId, $this->request, $shouldInterrupt)) {
			return true;
		} else {
			return false;
		}
	}
}
