<?php

namespace ZWE\Jobs;

use Symfony\Component\Validator\Constraints as Assert;
use ZWE\Container\ZWEApplicationContainerImpl;

class SendCustomMailJob extends AbstractSendMailJob
{

	/**
	 * @var \Mandator
	 * @Assert\NotNull()
	 */
	private $mandant;

	/**
	 * @var string
	 */
	private $subject;

	/**
	 * @var string
	 */
	private $html;

	/**
	 * @var array
	 */
	private $recipients;

	/**
	 * @var null|string|string[]
	 */
	private $attachments;

	protected function getValuesToSerialize()
	{
		return [
			'mandantId' => $this->mandant->id,
			'subject' => $this->subject,
			'html' => $this->html,
			'recipients' => $this->recipients,
			'attachments' => $this->attachments
		];
	}

	protected function unserializeInternal($unserializedValues)
	{
		parent::unserializeInternal($unserializedValues);
		$this->mandant = \Doctrine::getTable(\Mandator::class)->findOneBy('id', $unserializedValues['mandantId']);
		$this->subject = $unserializedValues['subject'];
		$this->html = $unserializedValues['html'];
		$this->recipients = $unserializedValues['recipients'];
		$this->attachments = $unserializedValues['attachments'];
	}

	/**
	 * @return \Mandator
	 */
	public function getMandant()
	{
		return $this->mandant;
	}

	/**
	 * @param \Mandator $mandant
	 * @return SendCustomMailJob
	 */
	public function setMandant($mandant)
	{
		$this->mandant = $mandant;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getSubject()
	{
		return $this->subject;
	}

	/**
	 * @param string $subject
	 * @return SendCustomMailJob
	 */
	public function setSubject($subject)
	{
		$this->subject = $subject;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getHtml()
	{
		return $this->html;
	}

	/**
	 * @param string $html
	 * @return SendCustomMailJob
	 */
	public function setHtml($html)
	{
		$this->html = $html;
		return $this;
	}

	/**
	 * @return array
	 */
	public function getRecipients()
	{
		return $this->recipients;
	}

	/**
	 * @param array $recipients
	 * @return SendCustomMailJob
	 */
	public function setRecipients($recipients)
	{
		$this->recipients = $recipients;
		return $this;
	}

	/**
	 * @return null|string|string[]
	 */
	public function getAttachments()
	{
		return $this->attachments;
	}

	/**
	 * @param null|string|string[] $attachments
	 * @return SendCustomMailJob
	 */
	public function setAttachments($attachments)
	{
		$this->attachments = $attachments;
		return $this;
	}

	public function run(callable $shouldInterrupt = null)
	{
		if ($this->container->getMailingService()->sendCustomMessage($this->messageId, $this->mandant, $this->subject, $this->html, $this->recipients,
			$this->attachments, $shouldInterrupt)) {
			return true;
		} else {
			return false;
		}
	}
}
