<?php

namespace ZWE\Jobs;

use Carbon\Carbon;
use Symfony\Component\Validator\Constraints as Assert;
use ZWE\Container\ZWEApplicationContainer;
use ZWE\Container\ZWEApplicationContainerImpl;
use ZWE\Queue\Job;
use ZWE\Settings\SettingsRegistry;
use ZWE\UUID;

class GdprDeleteUserJob implements Job
{

	/**
	 * @var ZWEApplicationContainer
	 * @Assert\NotNull()
	 */
	private $container;

	/**
	 * @var \User
	 * @Assert\NotNull()
	 */
	private $user;

	public function __construct(ZWEApplicationContainer $container)
	{
		$this->container = $container;
	}

	/**
	 * @return \User
	 */
	public function getUser()
	{
		return $this->user;
	}

	/**
	 * @param \User $user
	 * @return GpdrDeleteUserJob
	 */
	public function setUser($user)
	{
		$this->user = $user;
		return $this;
	}

	public function getName()
	{
		return GdprDeleteUserJob::class;
	}

	public function run(callable $shouldInterrupt = null)
	{
		$connection = \Doctrine_Manager::getInstance()->getCurrentConnection();
		try {
			$connection->beginTransaction();

			// ----------------
			// einsätze löschen
			// ----------------

			$assignments = \Doctrine_Query::create()->from('Assignment a')
				->innerJoin('a.WRTeam t')
				->innerJoin('t.Event e')
				->where('user_id = ?', $this->user->id)
				->andWhere('e.datum >= ?', Carbon::now()->format('Y-m-d'))
				->execute();

			/**
			 * @var $ass \Assignment
			 */
			foreach($assignments as $ass) {
				switch ($ass->state) {
					case \Assignment::STATE_DEFAULT:
						$ass->delete();
						break;
					case \Assignment::STATE_INVITED;
					case \Assignment::STATE_CONFIRMED:
						$ass->cancel(true);
						$this->container->getMailingService()->sendCancellationMessage(UUID::randomUUID(), $ass);
						break;
					default:
						break;
				}
			}

			// ----------------
			// benutzer löschen
			// ----------------

			$this->container->getMailingService()->sendUserDeletedMessage(UUID::randomUUID(), $this->user);
			// TODO: fehlerprüfung
			$deu = $this->container->getCountryRepo()->findByISOAlpha3('DEU');

			$verein0 = $this->container->getClubRepo()->findByDTVVnum(0);
			if (!$verein0) {
				$verein0 = new \Club();
				$verein0->vnum_dtv = 0;
				$verein0->name = '(gelöschte Benutzer)';
				$verein0->ltv_id = SettingsRegistry::getInstance()->get('zwe_ltv')->getValue();
				$verein0->country_id = $deu->id;
				// TODO: bessere logik
				$verein0->mandator_id = 1;
				$verein0->has_wr = 1;
				$verein0->save();
			}

			$this->user->liznr = null;
			$this->user->title = null;
			$this->user->name = 'N.';
			$this->user->surname = 'N.';
			$this->user->gender = \User::MALE;
			// TODO: notnull constraint
			$this->user->email = '';
			$this->user->phone = null;
			// TODO: notnull constraint
			$this->user->passwd = '';
			$this->user->Club = $verein0;
			// TODO: bessere logik
			$this->user->license_lat_id = 5;
			$this->user->license_st_id = 5;
			$this->user->updateEffectiveLicenses();
			$this->user->active = \User::STATE_DELETED;
			$this->user->lastlogin = null;
			$this->user->fails = 0;
			$this->user->activation_code = null;
			$this->user->chpw_code = null;
			$this->user->bemerkungen = null;
			$this->user->strasse = null;
			$this->user->plz = null;
			$this->user->ort = null;
			$this->user->Country = $deu;
			$this->user->mobile = null;
			$this->user->dtvnr = null;
			$this->user->geburtsjahr = null;
			$this->user->esv_check = null;
			$this->user->esv_data = null;
			$this->user->gdpr_terms_consent = null;
			$this->user->gdpr_terms_version = 0;
			$this->user->listing_consent = null;
			$this->user->save();

			// ---------------------
			// weitere daten löschen
			// ---------------------

			\Doctrine_Query::create()->delete()->from(\Availability::class)
				->where('user_id = ?', $this->user->id)->execute();
			\Doctrine_Query::create()->delete()->from(\ChangeEmailRequest::class)
				->where('user_id = ?', $this->user->id)->execute();

			$connection->commit();
			return true;
		} catch (\Exception $e) {
			$connection->rollback();
			throw $e;
		}
	}

	public function serialize()
	{
		return serialize([
			'userId' => $this->user->id
		]);
	}

	public function unserialize($serialized)
	{
		$this->container = ZWEApplicationContainerImpl::getInstance();
		$array = unserialize($serialized);
		$this->user = $this->container->getUserRepo()->find($array['userId']);
	}
}
