<?php

namespace ZWE\Jobs;

use Symfony\Component\Validator\Constraints as Assert;

abstract class AbstractSendEventBasedMailJob extends AbstractSendMailJob
{

	/**
	 * @var \Event
	 * @Assert\NotNull()
	 */
	protected $event;

	/**
	 * @var string
	 */
	protected $remarks;

	/**
	 * @return \Event
	 */
	public function getEvent()
	{
		return $this->event;
	}

	/**
	 * @param \Event $event
	 * @return $this
	 */
	public function setEvent($event)
	{
		$this->event = $event;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getRemarks()
	{
		return $this->remarks;
	}

	/**
	 * @param string $remarks
	 * @return AbstractSendEventBasedMailJob
	 */
	public function setRemarks($remarks)
	{
		$this->remarks = $remarks;
		return $this;
	}

	protected function getValuesToSerialize()
	{
		return [
			'eventId' => $this->event->id,
			'remarks' => $this->remarks
		];
	}

	protected function unserializeInternal($unserializedValues)
	{
		parent::unserializeInternal($unserializedValues);
		$this->event = \Doctrine::getTable(\Event::class)->findOneBy('id', $unserializedValues['eventId']);
		$this->remarks = $unserializedValues['remarks'];
	}
}
