<?php

namespace ZWE\Jobs;

use Symfony\Component\Validator\Constraints as Assert;

abstract class AbstractSendAssignmentBasedMailJob extends AbstractSendMailJob
{

	/**
	 * @var \Assignment
	 * @Assert\NotNull()
	 */
	protected $assignment;

	/**
	 * @var string
	 */
	protected $remarks;

	/**
	 * @return \Assignment
	 */
	public function getAssignment()
	{
		return $this->assignment;
	}

	/**
	 * @param \Assignment $assignment
	 * @return $this
	 */
	public function setAssignment($assignment)
	{
		$this->assignment = $assignment;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getRemarks()
	{
		return $this->remarks;
	}

	/**
	 * @param string $bemerkungen
	 * @return SendInvitationMailJob
	 */
	public function setRemarks($remarks)
	{
		$this->remarks = $remarks;
		return $this;
	}

	protected function getValuesToSerialize()
	{
		return [
			'assignment' => $this->assignment->toArray(true),
			'remarks' => $this->remarks
		];
	}

	protected function unserializeInternal($unserializedValues)
	{
		parent::unserializeInternal($unserializedValues);
		$this->assignment = new \Assignment();
		$this->assignment->fromArray($unserializedValues['assignment'], true);
		$this->remarks = $unserializedValues['remarks'];
	}
}
