<?php
namespace ZWE\Images;

use ZWE\FileStorage\FileImpl;

class ImageImpl extends FileImpl implements Image
{

	/**
	 * @var
	 */
	private $descriptor;

	/**
	 * @var array
	 */
	private $info;

	public function __construct($absolutePath, $descriptor)
	{
		parent::__construct($absolutePath);
		$this->descriptor = $descriptor;
	}

	public function getWidth()
	{
		$this->loadImageInfo();
		if ($this->info) {
			return $this->info[0];
		} else {
			return 0;
		}
	}

	public function getHeight()
	{
		$this->loadImageInfo();
		if ($this->info) {
			return $this->info[1];
		} else {
			return 0;
		}
	}

	/**
	 * @param $maxWidth
	 * @param $maxHeight
	 * @return array
	 */
	public function getScaledDimensions($maxWidth = null, $maxHeight = null)
	{
		$width = $this->getWidth();
		$height = $this->getHeight();
		if ($width > 0 && $height > 0) {
			if ($maxWidth != null && $maxHeight != null) {
				$ratio = $width / $height;
				$targetRatio = $maxWidth / $maxHeight;
				if ($ratio > $targetRatio) {
					return $this->scaleWidth($width, $height, $maxWidth);
				} else {
					return $this->scaleHeight($width, $height, $maxHeight);
				}
			} elseif ($maxWidth != null) {
				return $this->scaleWidth($width, $height, $maxWidth);
			} elseif ($maxHeight != null) {
				return $this->scaleHeight($width, $height, $maxHeight);
			} else {
				return array($width, $height);
			}
		} else {
			return array(0, 0);
		}
	}

	private function scaleWidth($width, $height, $maxWidth)
	{
		$targetWidth = $width < $maxWidth ? $width : $maxWidth;
		$targetHeight = round($targetWidth * $height / $width);
		return array($targetWidth, $targetHeight);
	}

	private function scaleHeight($width, $height, $maxHeight)
	{
		$targetHeight = $height < $maxHeight ? $height : $maxHeight;
		$targetWidth = round($targetHeight * $width / $height);
		return array($targetWidth, $targetHeight);
	}

	/**
	 * @param $maxWidth
	 * @param $maxHeight
	 * @return string
	 */
	public function getScaledDimensionsAsString($maxWidth = null, $maxHeight = null)
	{
		$dimensions = $this->getScaledDimensions($maxWidth, $maxHeight);
		return " width=\"{$dimensions[0]}\" height=\"{$dimensions[1]}\"";
	}

	/**
	 * @return array
	 */
	public function getDescriptor()
	{
		return $this->descriptor;
	}

	/**
	 * @param $key
	 * @return mixed
	 */
	public function getDescriptorValue($key)
	{
		if ($this->descriptor != null && isset($this->descriptor[$key])) {
			return $this->descriptor[$key];
		}
	}

	private function loadImageInfo()
	{
		if ($this->info == null) {
			$this->info = getimagesize($this->getAbsolutePath());
		}
	}

}
