<?php
namespace ZWE\FileStorage;

use Carbon\Carbon;

interface File
{

	/**
	 * @return void
	 */
	public function delete();

	/**
	 * @return string
	 */
	public function getAbsolutePath();

	/**
	 * @return string
	 */
	public function getMimeType();

	/**
	 * @return string
	 */
	public function getName();

	/**
	 * @return int
	 */
	public function getSize();

	/**
	 * @return Carbon
	 */
	public function getModified();

	/**
	 * @return bool
	 */
	public function exists();

	/**
	 * Sendet die Datei mit Content-disposition: attachment.
	 * @return void
	 */
	public function send();

	/**
	 * Zeigt die Datei mit Content-disposition: inline.
	 * @return void
	 */
	public function view();

	/**
	 * Liest eine Datei ein.
	 *
	 * @return string
	 */
	public function read();

	/**
	 * Schreibt den Inhalt in die Datei.
	 *
	 * @param $contents
	 * @return void
	 */
	public function write($contents);
}