<?php
namespace ZWE\Export\Freigaben;

use ZWE\FileStorage\File;

interface ExportPlanungExcel
{
	/**
	 * Erstellt das Dokument.
	 *
	 * @param \DateTime $from
	 * @param \DateTime $to
	 * @param mixed $eventMandanten
	 * @param mixed $wrMandanten
	 * @param mixed $ltvs
	 * @return mixed
	 */
	public function createDocument(\DateTime $from, \DateTime $to, $eventMandanten, $wrMandanten, $ltvs);

	/**
	 * Speichert die Datei im angegebenen Format.
	 *
	 * @param File $file
	 * @param string $format
	 * @return mixed
	 */
	public function saveAs(File $file, $format);

	/**
	 * Sendet die Datei mit Content-disposition: attachment mit dem angegebenen
	 * Format und Basis-Dateinamen.
	 *
	 * @param string $format Format
	 * @param string $baseFilename Basis-Dateiname
	 * @return mixed
	 */
	public function send($format, $baseFilename);

} 