<?php
namespace ZWE\ESV;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class IsDTVNummerValidator extends ConstraintValidator
{

	public function validate($value, Constraint $constraint)
	{
		if (trim($value) != '') {
			try {
				$valid = DTVNummer::fromString($value)->isValid();
			} catch (\InvalidArgumentException $e) {
				$valid = false;
			}

			if (!$valid) {
				$this->context->buildViolation($constraint->message)
					->setParameter('%dtvId%', $value)
					->addViolation();
			}
			return $valid;
		} else {
			return true;
		}
	}

}