<?php
namespace ZWE\ESV\ExportFormat\Model;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Type;
use ZWE\ESV\DTVNummer;
use ZWE\ESV\ESVLizenzen;

class ZEFWertungsrichterModel
{

	/**
	 * @var string
	 * @Expose
	 * @Type("string")
	 */
	private $id;

	/**
	 * @var int
	 * @Expose
	 * @Type("integer")
	 * @SerializedName("wdfsMin")
	 */
	private $wdsfMin;

	/**
	 * @var string
	 * @Expose
	 * @Type("string")
	 */
	private $titel;

	/**
	 * @var string
	 * @Expose
	 * @Type("string")
	 */
	private $vorname;

	/**
	 * @var string
	 * @Expose
	 * @Type("string")
	 */
	private $nachname;

	/**
	 * @var ZEFClubModel
	 * @Expose
	 * @Type("ZWE\ESV\ExportFormat\Model\ZEFClubModel")
	 */
	private $club;

	/**
	 * @var string
	 * @Expose
	 * @Type("string")
	 */
	private $staat;

	/**
	 * @var array
	 * @Expose
	 * @Type("array<string>")
	 */
	private $lizenzen = [];

	/**
	 * @var array
	 * @Expose
	 * @Type("array<string>")
	 */
	private $turniere = [];

	public function __construct(\User $user, \Club $club)
	{
		$this->id = null;
		if($user->dtvnr) {
			try {
				$dtvnr = DTVNummer::fromString($user->dtvnr);
				if($dtvnr->praefix == 'DE') {
					$this->id = $dtvnr->__toString();
				}
			}
			catch (\Exception $e) {
			}
		}
		$this->wdsfMin = null;
		$this->titel = $user->title;
		$this->vorname = $user->name;
		$this->nachname = $user->surname;
		$this->club = new ZEFClubModel($club);
		$this->staat = $club->Country->ioc;
		$this->lizenzen = ESVLizenzen::konvertiereZuESV($user);
	}
}