<?php
namespace ZWE\ESV;

use function ZWE\count_safe;

class ESVLizenzen
{

	// müssen in aufsteigener priorität sortiert sein!

	private static $mappings = [
		'WR-D' => 'D',
		'WR-C' => 'C',
		'WR-B-Std' => 'B',
		'WR-B-Lat' => 'B',
		'WR-A-Std' => 'A',
		'WR-A-Lat' => 'A',
		'WR-S-Std' => 'S',
		'WR-S-Lat' => 'S',
		'WR-S-RL-Std' => 'S',
		'WR-S-RL-Lat' => 'S',
		'WR-S-DM-Std' => 'S',
		'WR-S-DM-Lat' => 'S',
		'WR-S2-Std' => 'S2',
		'WR-S2-Lat' => 'S2'
	];

	private static $reverse = [
		'D' => 'WR-D',
		'C' => 'WR-C',
		'B' => 'WR-B',
		'A' => 'WR-A',
		'S' => 'WR-S',
		'S2' => 'WR-S2'
	];

	private static $withoutSuffix = [
		'D', 'C'
	];

	public static $SUFFIX_LAT = 'Lat';
	public static $SUFFIX_STD = 'Std';

	private function __construct()
	{
	}

	public static function hoechsteLizenzLat(array $esvLizenzen)
	{
		return self::hoechsteLizenz($esvLizenzen, self::$SUFFIX_LAT);
	}

	public static function hoechsteLizenzStd(array $esvLizenzen)
	{
		return self::hoechsteLizenz($esvLizenzen, self::$SUFFIX_STD);
	}

	private static function hoechsteLizenz(array $esvLizenzen, $suffix)
	{
		$lizenzenFuerSuffix = array_filter($esvLizenzen, function ($element) use ($suffix) {
			return isset(self::$mappings[$element]) && (strpos($element, $suffix) > 0 || $element == 'WR-D' || $element == 'WR-C');
		});
		$priosFuerSuffix = array_intersect(array_keys(self::$mappings), $lizenzenFuerSuffix);
		if (count_safe($priosFuerSuffix) > 0) {
			return array_pop($priosFuerSuffix);
		}
		// fall berücksichten, dass lizenzen fälschlicherweise nur in einer turnierart vergeben worden sind
		// wir ermitteln also, ob es einzel-lizenzen gibt, wenn bisher keine lizenz gefunden wurde und geben
		// dann die c-lizenz zurück
		if (count_safe(array_intersect(array_keys(self::$mappings), $esvLizenzen)) > 0) {
			return 'WR-C';
		}
	}

	public static function konvertiereHoechsteLizenzLat(array $esvLizenzen)
	{
		return self::konvertiereHoechsteLizenz($esvLizenzen, self::$SUFFIX_LAT);
	}

	public static function konvertiereHoechsteLizenzStd(array $esvLicenses)
	{
		return self::konvertiereHoechsteLizenz($esvLicenses, self::$SUFFIX_STD);
	}

	private static function konvertiereHoechsteLizenz(array $esvLicenses, $suffix)
	{
		return self::konvertiere(self::hoechsteLizenz($esvLicenses, $suffix));
	}

	private static function konvertiere($esvLicense)
	{
		if (!$esvLicense || !isset(self::$mappings[$esvLicense])) {
			return;
		}

		return self::$mappings[$esvLicense];
	}

	public static function konvertiereZuESV(\User $user)
	{
		if ($user->LicenseStEffective->shortname == 'D' || $user->LicenseLatEffective->shortname == 'D') {
			return [self::$reverse['D']];
		} else if ($user->LicenseStEffective->shortname == 'B') {
			// B-Lizenz in Standard gilt auch wenn A/S-Lizenz in Latein
			if (in_array($user->LicenseLatEffective->shortname, ['A', 'S'])) {
				return [self::findeESVSchluessel($user->LicenseStEffective, self::$SUFFIX_STD), self::findeESVSchluessel($user->LicenseStEffective, self::$SUFFIX_LAT)];
			}
		} else if ($user->LicenseLatEffective->shortname == 'B') {
			// B-Lizenz in Latein gilt auch wenn A/S-Lizenz in Standard
			if (in_array($user->LicenseStEffective->shortname, ['A', 'S'])) {
				return [self::findeESVSchluessel($user->LicenseLatEffective, self::$SUFFIX_STD), self::findeESVSchluessel($user->LicenseLatEffective, self::$SUFFIX_LAT)];
			}
		}
		return array_unique([self::findeESVSchluessel($user->LicenseStEffective, self::$SUFFIX_STD), self::findeESVSchluessel($user->LicenseLatEffective, self::$SUFFIX_LAT)]);
	}

	public static function findeESVSchluessel(\License $license, $suffix)
	{
		if (!$suffix) {
			throw new \InvalidArgumentException('Suffix erforderlich!');
		}

		foreach (self::$reverse as $zwe => $esv) {
			if ($zwe == $license->shortname) {
				if (in_array($license->shortname, self::$withoutSuffix)) {
					return $esv;
				} else {
					return $esv . '-' . $suffix;
				}
			}
		}
	}
}
