<?php

namespace ZWE\Context;

/**
 * Statischer ContextHolder, der die Kontext-Variable in einer
 * in einer Instanz-Variablen speichert.
 *
 * Diese Klasse wird im wesentlichen für Unit-Tests benötigt.
 *
 * @author  Hendrik Heneke <hendrik@pixelwunder.net>
 * @since   2.5
 */
class StaticContextHolder implements ContextHolder {

    private $contextVar = null;

    public function setContext($contextVar) {
        $this->contextVar = $contextVar;
    }

    public function getContext() {
        return $this->contextVar;
    }

    public function clearContext() {
        $this->contextVar = null;
    }

}