<?php

namespace ZWE\Container;

use Doctrine\Common\Annotations\AnnotationReader;
use JMS\Serializer\Serializer;
use Metadata\MetadataFactoryInterface;
use Rych\Random\Random;
use Symfony\Component\Translation\TranslatorInterface;
use Symfony\Component\Validator\Mapping\Loader\AnnotationLoader;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Tanzsport\ESV\API\Client;
use ZWE\ESV\DTVNummerGenerator;
use ZWE\ESV\ESVService;
use ZWE\ESV\ExportFormat\ExportZWEX;
use ZWE\Export\Einsatzplan\ExportEinsatzplanPDF;
use ZWE\Export\Einsatzplan\ExportEinsatzplanPDFImpl;
use ZWE\Export\Freigaben\ExportFreigabenExcel;
use ZWE\Export\Freigaben\ExportPlanungExcel;
use ZWE\FileStorage\FileStorage;
use ZWE\Images\ImageResourceService;
use ZWE\Jobs\JobFactory;
use ZWE\Mail\MailingService;
use ZWE\Mail\MailTextService;
use ZWE\Mail\MessageCreator;
use ZWE\Queue\Queue;
use ZWE\Queue\QueueDriver;
use ZWE\Repository\AssignmentplanRepository;
use ZWE\Repository\AssignmentRepository;
use ZWE\Repository\AvailabilityRepository;
use ZWE\Repository\ClubRepository;
use ZWE\Repository\CompetitionRepository;
use ZWE\Repository\CountryRepository;
use ZWE\Repository\DancetypeRepository;
use ZWE\Repository\EmailTextRepository;
use ZWE\Repository\EventRepository;
use ZWE\Repository\LicenseRepository;
use ZWE\Repository\LocationRepository;
use ZWE\Repository\LTVRepository;
use ZWE\Repository\RoleRepository;
use ZWE\Repository\StartclassRepository;
use ZWE\Repository\StartgroupRepository;
use ZWE\Repository\UserRepository;
use ZWE\Repository\WRTeamRepository;
use ZWE\Settings\SettingsRegistry;
use ZWE\User\PasswordResetService;

interface ZWEApplicationContainer
{

	/* === REPOSITORIES == */

	/**
	 * @return ZWEConfigurationSource
	 */
	public function getConfigurationSource();

	/**
	 * @return AssignmentplanRepository
	 */
	public function getAssignmentplanRepo();

	/**
	 * @return AssignmentRepository
	 */
	public function getAssignmentRepo();

	/**
	 * @return AvailabilityRepository
	 */
	public function getAvailabilityRepo();

	/**
	 * @return ClubRepository
	 */
	public function getClubRepo();

	/**
	 * @return CompetitionRepository
	 */
	public function getCompetitionRepo();

	/**
	 * @return DancetypeRepository
	 */
	public function getDancetypeRepo();

	/**
	 * @return EventRepository
	 */
	public function getEventRepo();

	/**
	 * @return LicenseRepository
	 */
	public function getLicenseRepo();

	/**
	 * @return LocationRepository
	 */
	public function getLocationRepo();

	/**
	 * @return LTVRepository
	 */
	public function getLTVRepo();

	/**
	 * @return RoleRepository
	 */
	public function getRoleRepo();

	/**
	 * @return StartclassRepository
	 */
	public function getStartclassRepo();

	/**
	 * @return StartgroupRepository
	 */
	public function getStartgroupRepo();

	/**
	 * @return UserRepository
	 */
	public function getUserRepo();

	/**
	 * @return WRTeamRepository
	 */
	public function getWRTeamRepo();

	/**
	 * @return EmailTextRepository
	 */
	public function getEmailTextRepo();

	/**
	 * @return CountryRepository
	 */
	public function getCountryRepo();

	/* === STORAGE === */

	/**
	 * @return FileStorage;
	 */
	public function getAssignmentplanStorage();

	/**
	 * @return FileStorage
	 */
	public function getResourceStorage();

	/**
	 * @return FileStorage
	 */
	public function getTempStorage();

	/**
	 * @return FileStorage
	 */
	public function getWorkspaceStorage();

	/* === GET SERVIVCES === */

	/**
	 * @return SettingsRegistry
	 */
	public function getSettingsService();

	/**
	 * @return MessageCreator
	 */
	public function getMessageCreator();

	/**
	 * @return MailingService
	 */
	public function getMailingService();

	/**
	 * @return MailTextService
	 */
	public function getMailTextService();

	/**
	 * @return PasswordResetService
	 */
	public function getPasswordResetService();

	/**
	 * @return ImageResourceService
	 */
	public function getImageResourceService();

	/**
	 * @return DTVNummerGenerator
	 */
	public function getDTVNummerGenerator();

	/**
	 * @return Client
	 */
	public function getEsvClient();

	/**
	 * @return ESVService
	 */
	public function getEsvService();

	/**
	 * @return Serializer
	 */
	public function getSerializer();

	/**
	 * @return TranslatorInterface
	 */
	public function getTranslator();

	/**
	 * @return AnnotationReader
	 */
	public function getAnnotationReader();

	/**
	 * @return AnnotationLoader
	 */
	public function getAnnotationLoader();

	/**
	 * @return MetadataFactoryInterface
	 */
	public function getMetadataFactory();

	/**
	 * @return ValidatorInterface
	 */
	public function getValidator();

	/**
	 * @return Random
	 */
	public function getRandom();

	/**
	 * @return LoggingService
	 */
	public function getLoggingService();

	/**
	 * @return Queue
	 */
	public function getQueue();

	/**
	 * @return QueueDriver
	 */
	public function getQueueDriver();

	/**
	 * @return JobFactory
	 */
	public function getJobFactory();

	/* === PDO === */

	/**
	 * @return \PDO
	 */
	public function getPDO();

	/* === GET NON-SINGLETONS === */

	/**
	 * @return ExportEinsatzplanPDF
	 */
	public function getNewExportEinsatzplan();

	/**
	 * @return ExportFreigabenExcel
	 */
	public function getNewExportFreigaben();

	/**
	 * @return ExportPlanungExcel
	 */
	public function getNewExportPlanung();

	/**
	 * @param \Event $event
	 * @return FileStorage
	 */
	public function getNewEventAttachmentStorage(\Event $event);

	/**
	 * @return ExportZWEX
	 */
	public function getNewExportZWEX();

	/* === MISC === */

	/**
	 * @return bool
	 */
	public function isLoadInternalMessageHelpers();

	/**
	 * @return array
	 */
	public function getRequiredExtensions();

	/**
	 * @return array
	 */
	public function getOptionalExtensions();

	/**
	 * @return array
	 */
	public function getExtensions();

	/**
	 * @return bool
	 */
	public function isInstalledInVendorDir();

	/**
	 * Returns the real path to the vendor directory if installed as a composer dependency, otherwise null
	 *
	 * @return mixed
	 */
	public function getVendorDir();
}
