<?php

namespace ZWE\Container;

use Monolog\Handler\RotatingFileHandler;
use Monolog\Logger;
use Psr\Log\LoggerInterface;

class LoggingServiceImpl implements LoggingService
{

	/**
	 * @var ZWEApplicationContainer
	 */
	private $app;

	/**
	 * @var LoggerInterface[]
	 */
	private $loggers;

	/**
	 * @var RotatingFileHandler[]
	 */
	private $handlers;

	public function __construct(ZWEApplicationContainer $app)
	{
		$this->app = $app;
		$this->loggers = [];
		$this->handlers = [];
	}

	public function createLogger($name)
	{
		if (isset($this->loggers[$name])) {
			return $this->loggers[$name];
		}

		$logger = new Logger($name);
		$logger->pushHandler($this->getOrCreateHandler());
		return $logger;
	}

	private function getOrCreateHandler()
	{
		$handlerType = strpos(php_sapi_name(), 'cli') !== false ? 'cli' : 'web';
		if (!isset($this->handlers[$handlerType])) {
			$this->handlers[$handlerType] = new RotatingFileHandler("{$this->getLogPath()}/{$handlerType}.log", 7, $this->getLogLevel(), true);
		}

		return $this->handlers[$handlerType];
	}

	private function getLogPath()
	{
		return $this->app->getConfigurationSource()['log_path'];
	}

	private function getLogLevel()
	{
		$level = $this->app->getConfigurationSource()['log_threshold'];
		switch ($level) {
			case 4:
				return Logger::DEBUG;
			case 3:
				return Logger::INFO;
			case 2:
				return Logger::WARNING;
			case 1:
				return LOGGER::ERROR;
			case 0:
				return PHP_INT_MAX;
		}
	}
}