<?php
namespace ZWE\Calendar;

class CalendarSheetFactory
{

	private $previoussheet;
	private $previousyearsheet;
	private $sheet;
	private $nextsheet;
	private $nextyearsheet;

	public function __construct($startyear = 2009, $startmonth = 1, $user = NULL)
	{
		$this->sheet = new CalendarSheet($startyear, $startmonth, $user);
	}

	public function adjust($year, $month, $user = NULL)
	{
		$this->sheet->adjust($year, $month, $user);
		$this->previoussheet = NULL;
		$this->previousyearsheet = NULL;
		$this->nextsheet = NULL;
		$this->nextyearsheet = NULL;
	}

	public function getSheet()
	{
		return $this->sheet;
	}

	public function getNextSheet()
	{
		if ($this->nextsheet == NULL) {
			$this->nextsheet = $this->sheet->nextSheet();
		}
		return $this->nextsheet;
	}

	public function getNextYearSheet()
	{
		if ($this->nextyearsheet == NULL) {
			$this->nextyearsheet = $this->sheet->nextYearSheet();
		}
		return $this->nextyearsheet;
	}

	public function getPreviousSheet()
	{
		if ($this->previoussheet == NULL) {
			$this->previoussheet = $this->sheet->previousSheet();
		}
		return $this->previoussheet;
	}

	public function getPreviousYearSheet()
	{
		if ($this->previousyearsheet == NULL) {
			$this->previousyearsheet = $this->sheet->previousYearSheet();
		}
		return $this->previousyearsheet;
	}

}
