<?php

ini_set('auto_detect_line_endings', true);

function read_countries_csv()
{
	$csv = __DIR__ . '/../csv/countries.csv';
	if (!file_exists($csv)) {
		throw new RuntimeException('CSV-Datei existiert nicht!');
	}

	$fp = fopen($csv, 'r');
	if (!$fp) {
		throw new RuntimeException('CSV-Datei konnte nicht geöffnet werden!');
	}

	$countries = [];
	$id = 0;
	while ($line = fgetcsv($fp, 0, ';')) {
		if ($id !== 0 && $line[0]) {
			$countries[] = (object) [
				'id' => $id,
				'name' => $line[0],
				'ioc' => $line[3],
				'alpha3' => $line[2],
			];
		}
		$id++;
	}
	fclose($fp);
	return $countries;
}
