<?php

/**
 * BasePersistentSetting
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                $id                        Type: integer(4), primary key
 * @property string             $name                      Type: string(48)
 * @property string             $category                  Type: string(1) fixed-size
 * @property int                $user_id                   Type: integer(4)
 * @property int                $mandator_id               Type: integer(4)
 * @property string             $value                     Type: string
 * @property User               $User                      
 * @property Mandator           $Mandator                  
 *  
 * @method int                  getId()                    Type: integer(4), primary key
 * @method string               getName()                  Type: string(48)
 * @method string               getCategory()              Type: string(1) fixed-size
 * @method int                  getUserId()                Type: integer(4)
 * @method int                  getMandatorId()            Type: integer(4)
 * @method string               getValue()                 Type: string
 * @method User                 getUser()                  
 * @method Mandator             getMandator()              
 *  
 * @method PersistentSetting    setId(int $val)            Type: integer(4), primary key
 * @method PersistentSetting    setName(string $val)       Type: string(48)
 * @method PersistentSetting    setCategory(string $val)   Type: string(1) fixed-size
 * @method PersistentSetting    setUserId(int $val)        Type: integer(4)
 * @method PersistentSetting    setMandatorId(int $val)    Type: integer(4)
 * @method PersistentSetting    setValue(string $val)      Type: string
 * @method PersistentSetting    setUser(User $val)         
 * @method PersistentSetting    setMandator(Mandator $val) 
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BasePersistentSetting extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('settings');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('name', 'string', 48, array(
             'type' => 'string',
             'fixed' => 0,
             'notnull' => true,
             'length' => '48',
             ));
        $this->hasColumn('category', 'string', 1, array(
             'type' => 'string',
             'fixed' => 1,
             'notnull' => true,
             'length' => '1',
             ));
        $this->hasColumn('user_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'notnull' => false,
             'length' => '4',
             ));
        $this->hasColumn('mandator_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'notnull' => false,
             'length' => '4',
             ));
        $this->hasColumn('value', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'notnull' => false,
             ));


        $this->index('settings_name_category_mandator_user', array(
             'fields' => 
             array(
              0 => 'name',
              1 => 'category',
              2 => 'mandator_id',
              3 => 'user_id',
             ),
             'type' => 'unique',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('User', array(
             'local' => 'user_id',
             'foreign' => 'id'));

        $this->hasOne('Mandator', array(
             'local' => 'mandator_id',
             'foreign' => 'id'));
    }
}