<?php

/**
 * BaseMandator
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                      $id                                            Type: integer(4), primary key
 * @property string                                   $name                                          Type: string(48)
 * @property string                                   $icon_url                                      Type: string
 * @property Doctrine_Collection|User[]               $Operators                                     
 * @property Doctrine_Collection|Club[]               $Clubs                                         
 * @property Doctrine_Collection|Location[]           $Location                                      
 * @property Doctrine_Collection|User[]               $DefaultForZWEs                                
 * @property Doctrine_Collection|User[]               $PrimaryForZWEs                                
 * @property Doctrine_Collection|Event[]              $events                                        
 * @property Doctrine_Collection|PersistentSetting[]  $PersistentSetting                             
 * @property Doctrine_Collection|MandatorGrant[]      $MandatorGrants                                
 * @property Doctrine_Collection|LTV[]                $DefaultForLTV                                 
 *  
 * @method int                                        getId()                                        Type: integer(4), primary key
 * @method string                                     getName()                                      Type: string(48)
 * @method string                                     getIconUrl()                                   Type: string
 * @method Doctrine_Collection|User[]                 getOperators()                                 
 * @method Doctrine_Collection|Club[]                 getClubs()                                     
 * @method Doctrine_Collection|Location[]             getLocation()                                  
 * @method Doctrine_Collection|User[]                 getDefaultForZWEs()                            
 * @method Doctrine_Collection|User[]                 getPrimaryForZWEs()                            
 * @method Doctrine_Collection|Event[]                getEvents()                                    
 * @method Doctrine_Collection|PersistentSetting[]    getPersistentSetting()                         
 * @method Doctrine_Collection|MandatorGrant[]        getMandatorGrants()                            
 * @method Doctrine_Collection|LTV[]                  getDefaultForLTV()                             
 *  
 * @method Mandator                                   setId(int $val)                                Type: integer(4), primary key
 * @method Mandator                                   setName(string $val)                           Type: string(48)
 * @method Mandator                                   setIconUrl(string $val)                        Type: string
 * @method Mandator                                   setOperators(Doctrine_Collection $val)         
 * @method Mandator                                   setClubs(Doctrine_Collection $val)             
 * @method Mandator                                   setLocation(Doctrine_Collection $val)          
 * @method Mandator                                   setDefaultForZWEs(Doctrine_Collection $val)    
 * @method Mandator                                   setPrimaryForZWEs(Doctrine_Collection $val)    
 * @method Mandator                                   setEvents(Doctrine_Collection $val)            
 * @method Mandator                                   setPersistentSetting(Doctrine_Collection $val) 
 * @method Mandator                                   setMandatorGrants(Doctrine_Collection $val)    
 * @method Mandator                                   setDefaultForLTV(Doctrine_Collection $val)     
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseMandator extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('mandators');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('name', 'string', 48, array(
             'type' => 'string',
             'fixed' => 0,
             'notnull' => true,
             'length' => '48',
             ));
        $this->hasColumn('icon_url', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'notnull' => false,
             ));


        $this->index('ix_mandators_name', array(
             'fields' => 
             array(
              0 => 'name',
             ),
             'type' => 'unique',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('User as Operators', array(
             'refClass' => 'MandatorGrant',
             'local' => 'mandator_id',
             'foreign' => 'user_id'));

        $this->hasMany('Club as Clubs', array(
             'local' => 'id',
             'foreign' => 'mandator_id'));

        $this->hasMany('Location', array(
             'local' => 'id',
             'foreign' => 'mandator_id'));

        $this->hasMany('User as DefaultForZWEs', array(
             'local' => 'id',
             'foreign' => 'default_mandator_id'));

        $this->hasMany('User as PrimaryForZWEs', array(
             'local' => 'id',
             'foreign' => 'primary_mandator_id'));

        $this->hasMany('Event as events', array(
             'local' => 'id',
             'foreign' => 'mandator_id'));

        $this->hasMany('PersistentSetting', array(
             'local' => 'id',
             'foreign' => 'mandator_id'));

        $this->hasMany('MandatorGrant as MandatorGrants', array(
             'local' => 'id',
             'foreign' => 'mandator_id'));

        $this->hasMany('LTV as DefaultForLTV', array(
             'local' => 'id',
             'foreign' => 'default_mandator_id'));
    }
}