<?php

/**
 * BaseLocation
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                          $id                                 Type: integer(4), primary key
 * @property string                       $name                               Type: string(64)
 * @property string                       $address                            Type: string
 * @property string                       $strasse                            Type: string(48)
 * @property string                       $plz                                Type: string(12)
 * @property string                       $ort                                Type: string(48)
 * @property int                          $land_id                            Type: integer(4)
 * @property float                        $breitengrad                        Type: decimal(8)
 * @property float                        $laengengrad                        Type: decimal(9)
 * @property bool                         $auto_geokodiert                    Type: boolean
 * @property int                          $mandator_id                        Type: integer(4)
 * @property Doctrine_Collection|Event[]  $events                             
 * @property Mandator                     $Owner                              
 * @property Country                      $Country                            
 *  
 * @method int                            getId()                             Type: integer(4), primary key
 * @method string                         getName()                           Type: string(64)
 * @method string                         getAddress()                        Type: string
 * @method string                         getStrasse()                        Type: string(48)
 * @method string                         getPlz()                            Type: string(12)
 * @method string                         getOrt()                            Type: string(48)
 * @method int                            getLandId()                         Type: integer(4)
 * @method float                          getBreitengrad()                    Type: decimal(8)
 * @method float                          getLaengengrad()                    Type: decimal(9)
 * @method bool                           getAutoGeokodiert()                 Type: boolean
 * @method int                            getMandatorId()                     Type: integer(4)
 * @method Doctrine_Collection|Event[]    getEvents()                         
 * @method Mandator                       getOwner()                          
 * @method Country                        getCountry()                        
 *  
 * @method Location                       setId(int $val)                     Type: integer(4), primary key
 * @method Location                       setName(string $val)                Type: string(64)
 * @method Location                       setAddress(string $val)             Type: string
 * @method Location                       setStrasse(string $val)             Type: string(48)
 * @method Location                       setPlz(string $val)                 Type: string(12)
 * @method Location                       setOrt(string $val)                 Type: string(48)
 * @method Location                       setLandId(int $val)                 Type: integer(4)
 * @method Location                       setBreitengrad(float $val)          Type: decimal(8)
 * @method Location                       setLaengengrad(float $val)          Type: decimal(9)
 * @method Location                       setAutoGeokodiert(bool $val)        Type: boolean
 * @method Location                       setMandatorId(int $val)             Type: integer(4)
 * @method Location                       setEvents(Doctrine_Collection $val) 
 * @method Location                       setOwner(Mandator $val)             
 * @method Location                       setCountry(Country $val)            
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLocation extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('locations');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('name', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '64',
             ));
        $this->hasColumn('address', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '',
             ));
        $this->hasColumn('strasse', 'string', 48, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '48',
             ));
        $this->hasColumn('plz', 'string', 12, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '12',
             ));
        $this->hasColumn('ort', 'string', 48, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '48',
             ));
        $this->hasColumn('land_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('breitengrad', 'decimal', 8, array(
             'type' => 'decimal',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '8',
             'scale' => ' 6',
             ));
        $this->hasColumn('laengengrad', 'decimal', 9, array(
             'type' => 'decimal',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '9',
             'scale' => ' 6',
             ));
        $this->hasColumn('auto_geokodiert', 'boolean', null, array(
             'type' => 'boolean',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'default' => false,
             ));
        $this->hasColumn('mandator_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('Event as events', array(
             'local' => 'id',
             'foreign' => 'location_id'));

        $this->hasOne('Mandator as Owner', array(
             'local' => 'mandator_id',
             'foreign' => 'id'));

        $this->hasOne('Country', array(
             'local' => 'land_id',
             'foreign' => 'id'));
    }
}