<?php

/**
 * BaseClub
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                          $id                                 Type: integer(4), primary key
 * @property int                          $vnum_dtv                           Type: integer(4)
 * @property string                       $ltv_id                             Type: string(12)
 * @property string                       $name                               Type: string(64)
 * @property int                          $mandator_id                        Type: integer(4)
 * @property string                       $email                              Type: string(64)
 * @property string                       $phone                              Type: string(24)
 * @property string                       $correspondent                      Type: string(64)
 * @property int                          $ausrichter                         Type: integer(4), default "0"
 * @property int                          $auswaertig                         Type: integer(4), default "0"
 * @property int                          $has_wr                             Type: integer(4), default "0"
 * @property int                          $country_id                         Type: integer(4)
 * @property Doctrine_Collection|User[]   $Users                              
 * @property Mandator                     $Owner                              
 * @property Doctrine_Collection|Event[]  $events                             
 * @property LTV                          $LTV                                
 * @property Country                      $Country                            
 *  
 * @method int                            getId()                             Type: integer(4), primary key
 * @method int                            getVnumDtv()                        Type: integer(4)
 * @method string                         getLtvId()                          Type: string(12)
 * @method string                         getName()                           Type: string(64)
 * @method int                            getMandatorId()                     Type: integer(4)
 * @method string                         getEmail()                          Type: string(64)
 * @method string                         getPhone()                          Type: string(24)
 * @method string                         getCorrespondent()                  Type: string(64)
 * @method int                            getAusrichter()                     Type: integer(4), default "0"
 * @method int                            getAuswaertig()                     Type: integer(4), default "0"
 * @method int                            getHasWr()                          Type: integer(4), default "0"
 * @method int                            getCountryId()                      Type: integer(4)
 * @method Doctrine_Collection|User[]     getUsers()                          
 * @method Mandator                       getOwner()                          
 * @method Doctrine_Collection|Event[]    getEvents()                         
 * @method LTV                            getLTV()                            
 * @method Country                        getCountry()                        
 *  
 * @method Club                           setId(int $val)                     Type: integer(4), primary key
 * @method Club                           setVnumDtv(int $val)                Type: integer(4)
 * @method Club                           setLtvId(string $val)               Type: string(12)
 * @method Club                           setName(string $val)                Type: string(64)
 * @method Club                           setMandatorId(int $val)             Type: integer(4)
 * @method Club                           setEmail(string $val)               Type: string(64)
 * @method Club                           setPhone(string $val)               Type: string(24)
 * @method Club                           setCorrespondent(string $val)       Type: string(64)
 * @method Club                           setAusrichter(int $val)             Type: integer(4), default "0"
 * @method Club                           setAuswaertig(int $val)             Type: integer(4), default "0"
 * @method Club                           setHasWr(int $val)                  Type: integer(4), default "0"
 * @method Club                           setCountryId(int $val)              Type: integer(4)
 * @method Club                           setUsers(Doctrine_Collection $val)  
 * @method Club                           setOwner(Mandator $val)             
 * @method Club                           setEvents(Doctrine_Collection $val) 
 * @method Club                           setLTV(LTV $val)                    
 * @method Club                           setCountry(Country $val)            
 *  
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseClub extends Doctrine_Record
{
    public function setTableDefinition()
    {
        $this->setTableName('clubs');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => true,
             'autoincrement' => true,
             'length' => '4',
             ));
        $this->hasColumn('vnum_dtv', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('ltv_id', 'string', 12, array(
             'type' => 'string',
             'fixed' => 0,
             'notnull' => true,
             'length' => '12',
             ));
        $this->hasColumn('name', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '64',
             ));
        $this->hasColumn('mandator_id', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('email', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '64',
             ));
        $this->hasColumn('phone', 'string', 24, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '24',
             ));
        $this->hasColumn('correspondent', 'string', 64, array(
             'type' => 'string',
             'fixed' => 0,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '64',
             ));
        $this->hasColumn('ausrichter', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('auswaertig', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('has_wr', 'integer', 4, array(
             'type' => 'integer',
             'unsigned' => 0,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => '4',
             ));
        $this->hasColumn('country_id', 'integer', 4, array(
             'type' => 'integer',
             'primary' => false,
             'notnull' => false,
             'unsigned' => false,
             'length' => '4',
             ));


        $this->index('ix_clubs_vnum_dtv', array(
             'fields' => 
             array(
              0 => 'vnum_dtv',
             ),
             'type' => 'unique',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('User as Users', array(
             'local' => 'id',
             'foreign' => 'club_id'));

        $this->hasOne('Mandator as Owner', array(
             'local' => 'mandator_id',
             'foreign' => 'id'));

        $this->hasMany('Event as events', array(
             'local' => 'id',
             'foreign' => 'club_id'));

        $this->hasOne('LTV', array(
             'local' => 'ltv_id',
             'foreign' => 'id'));

        $this->hasOne('Country', array(
             'local' => 'country_id',
             'foreign' => 'id'));
    }
}